/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.gear.util.GearHelper;

public class CoreMachete
extends CoreSword {
    private static final int BREAK_RANGE = 2;

    public CoreMachete() {
        super(ToolType.AXE);
    }

    @Override
    public GearType getGearType() {
        return GearType.MACHETE;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == CommonItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(4.0f));
        }
        if (stat == CommonItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-2.6f));
        }
        if (stat == CommonItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == CommonItemStats.DURABILITY) {
            return Optional.of(StatInstance.makeGearMod(0.2f));
        }
        if (stat == CommonItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.1f));
        }
        return Optional.empty();
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return ModItems.sickle.onSickleStartBreak(itemstack, pos, player, 2);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return GearHelper.getHarvestLevel(stack, tool, blockState, null);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float speed = GearHelper.getDestroySpeed(stack, state, CoreAxe.EXTRA_EFFECTIVE_MATERIALS);
        if (state.func_185904_a() == Material.field_151575_d || state.func_185904_a() == Material.field_151572_C || state.func_185904_a() == Material.field_151594_q) {
            return speed * 0.4f;
        }
        return speed;
    }
}

