/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemTool;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreSickle
extends ItemTool
implements ICoreTool {
    public static final ToolType TOOL_TYPE = ToolType.get((String)"sickle");
    private static final int DURABILITY_USAGE = 2;
    private static final int BREAK_RANGE = 4;
    private static final int HARVEST_RANGE = 2;
    private static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151570_A, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151569_G);

    public CoreSickle() {
        super(0.0f, 0.0f, (IItemTier)ItemTier.DIAMOND, (Set)ImmutableSet.of(), GearHelper.getBuilder(TOOL_TYPE));
        GearHelper.addModelTypeProperty(this);
    }

    @Override
    public GearType getGearType() {
        return GearType.SICKLE;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == CommonItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == CommonItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-1.8f));
        }
        if (stat == CommonItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        BlockPos pos;
        ItemStack sickle = context.func_195996_i();
        if (GearHelper.isBroken(sickle)) {
            return EnumActionResult.PASS;
        }
        World world = context.func_195991_k();
        IBlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (!(state.func_177230_c() instanceof IGrowable)) {
            return EnumActionResult.PASS;
        }
        boolean somethingHarvested = false;
        int radius = 2;
        EntityPlayer player = context.func_195999_j();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)sickle);
        for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
            for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                IGrowable crop;
                BlockPos target = new BlockPos(x, pos.func_177956_o(), z);
                state = world.func_180495_p(target);
                Block block = state.func_177230_c();
                if (!(block instanceof IGrowable) || block instanceof BlockDoublePlant || (crop = (IGrowable)block).func_176473_a((IBlockReader)world, target, state, world.field_72995_K)) continue;
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(state, drops, world, target, fortune);
                ForgeEventFactory.fireBlockHarvesting((NonNullList)drops, (World)world, (BlockPos)target, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
                boolean foundSeed = false;
                for (ItemStack drop : drops) {
                    if (!foundSeed && drop.func_77973_b() instanceof IPlantable) {
                        IPlantable seed = (IPlantable)drop.func_77973_b();
                        if (seed.getPlant((IBlockReader)world, target) != block.func_176223_P()) continue;
                        foundSeed = true;
                        continue;
                    }
                    Block.func_180635_a((World)world, (BlockPos)target, (ItemStack)drop);
                }
                world.func_180501_a(target, block.func_176223_P(), 2);
                somethingHarvested = true;
            }
        }
        if (somethingHarvested) {
            GearHelper.attemptDamage(sickle, 2, (EntityLivingBase)player);
            if (player != null) {
                player.func_71020_j(0.02f);
            }
        }
        return somethingHarvested ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public boolean onBlockStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player) {
        return this.onSickleStartBreak(sickle, pos, player, 4);
    }

    boolean onSickleStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player, int range) {
        if (GearHelper.isBroken(sickle)) {
            return false;
        }
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (!EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return false;
        }
        int blocksBroken = 1;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                BlockPos target = new BlockPos(xPos, y, zPos);
                if (xPos == x && zPos == z || world.func_180495_p(target) != state || !this.breakExtraBlock(sickle, world, target, player)) continue;
                ++blocksBroken;
            }
        }
        return super.onBlockStartBreak(sickle, pos, player);
    }

    private boolean breakExtraBlock(ItemStack sickle, World world, BlockPos pos, EntityPlayer player) {
        boolean canceled;
        if (world.func_175623_d(pos) || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return false;
        }
        int xpDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (playerMP.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, false, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((IBlockReader)world, pos));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, (EntityPlayer)playerMP);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
                block.func_180657_a(world, player, pos, state, null, sickle);
                block.func_180637_b(world, pos, xpDropped);
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((IBlockReader)world, pos));
        } else {
            world.func_175718_b(2001, pos, Block.func_196246_j((IBlockState)state));
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            sickle.func_179548_a(world, state, pos, (EntityPlayer)playerMP);
        }
        return true;
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, World world, IBlockState state, BlockPos pos) {
        return 2;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_185904_a() == Material.field_151569_G;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return GearHelper.getDestroySpeed(stack, state, EFFECTIVE_MATERIALS);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return GearHelper.getHarvestLevel(stack, tool, blockState, EFFECTIVE_MATERIALS);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, GearHelper.calcDamageClamped(stack, damage));
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(null, stack);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.DURABILITY);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

