/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartDisplay;
import net.silentchaos512.gear.parts.PartMaterial;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public abstract class AbstractGearPart
implements IGearPart {
    private final ResourceLocation name;
    PartMaterial materials = new PartMaterial();
    int tier;
    StatModifierMap stats = new StatModifierMap();
    Map<ITrait, Integer> traits = new LinkedHashMap<ITrait, Integer>();
    ITextComponent displayName;
    final Map<String, PartDisplay> display = new HashMap<String, PartDisplay>();
    int modelIndex;
    private static int lastModelIndex;

    public AbstractGearPart(ResourceLocation location) {
        this.name = location;
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public IPartMaterial getMaterials() {
        return this.materials;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        ArrayList<StatInstance> mods = new ArrayList<StatInstance>(this.stats.get(stat));
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Override
    public Map<ITrait, Integer> getTraits(ItemStack gear, PartData part) {
        return ImmutableMap.copyOf(this.traits);
    }

    @Override
    public StatInstance.Operation getDefaultStatOperation(ItemStat stat) {
        return stat == CommonItemStats.HARVEST_LEVEL ? StatInstance.Operation.MAX : StatInstance.Operation.ADD;
    }

    @Override
    public float getRepairAmount(RepairContext context) {
        PartData material = context.getMaterial();
        if (material.getType() != PartType.MAIN) {
            return 0.0f;
        }
        PartData gearPrimary = GearData.getPrimaryPart(context.getGear());
        if (gearPrimary != null && material.getTier() < gearPrimary.getTier()) {
            return 0.0f;
        }
        Collection<StatInstance> mods = this.getStatModifiers(context.getGear(), CommonItemStats.DURABILITY, material);
        float durability = CommonItemStats.DURABILITY.compute(0.0f, mods);
        switch (context.getRepairType()) {
            case QUICK: {
                return ((Double)Config.GENERAL.repairFactorQuick.get()).floatValue() * durability;
            }
            case ANVIL: {
                return ((Double)Config.GENERAL.repairFactorAnvil.get()).floatValue() * durability;
            }
        }
        throw new IllegalArgumentException("Unknown RepairContext: " + context);
    }

    @Override
    public IPartDisplay getDisplayProperties(PartData part, ItemStack gear, int animationFrame) {
        if (!gear.func_190926_b()) {
            GearType gearType = ((ICoreItem)gear.func_77973_b()).getGearType();
            String typeName = gearType.getName();
            if (this.display.containsKey(typeName)) {
                return this.display.get(typeName);
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key)) continue;
                return this.display.get(key);
            }
        }
        return this.display.get("all");
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position, int animationFrame) {
        IPartDisplay props = this.getDisplayProperties(part, gear, animationFrame);
        String path = "item/" + gearClass + "/" + position.getTexturePrefix() + "_" + props.getTextureSuffix();
        return new ResourceLocation(props.getTextureDomain(), path);
    }

    @Override
    @Nullable
    public ResourceLocation getBrokenTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position) {
        return this.getTexture(part, gear, gearClass, position, 0);
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int animationFrame) {
        IPartDisplay props = this.getDisplayProperties(part, gear, animationFrame);
        if (!gear.func_190926_b()) {
            if (GearHelper.isBroken(gear)) {
                return props.getBrokenColor();
            }
            if (GearHelper.shouldUseFallbackColor(gear, part)) {
                return props.getFallbackColor();
            }
        }
        return props.getNormalColor();
    }

    @Override
    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (this.displayName == null) {
            return new TextComponentString("<error: missing name>");
        }
        return this.displayName;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    @Override
    public String getModelIndex(PartData part, int animationFrame) {
        return this.modelIndex + (animationFrame == 3 ? "_3" : "");
    }

    @Override
    public void addInformation(PartData part, ItemStack gear, List<ITextComponent> tooltip, ITooltipFlag flag) {
    }

    public String toString() {
        return "AbstractGearPart{" + this.name + "}";
    }

    public static class Serializer<T extends AbstractGearPart>
    implements IPartSerializer<T> {
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> function;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> function) {
            this.serializerId = serializerId;
            this.function = function;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            JsonElement elementAvailability;
            JsonElement elementName;
            JsonObject craftingSmall;
            JsonObject craftingItems;
            JsonObject craftingNormal;
            JsonObject obj;
            JsonElement elementTraits;
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonArray()) {
                JsonArray array = elementStats.getAsJsonArray();
                StatModifierMap statMap = new StatModifierMap();
                for (Iterator element : array) {
                    JsonObject obj2 = element.getAsJsonObject();
                    String name = JsonUtils.func_151219_a((JsonObject)obj2, (String)"name", (String)"");
                    ItemStat stat2 = ItemStat.ALL_STATS.get(name);
                    if (stat2 == null) continue;
                    float value = JsonUtils.func_151221_a((JsonObject)obj2, (String)"value", (float)0.0f);
                    StatInstance.Operation op = obj2.has("op") ? StatInstance.Operation.byName(JsonUtils.func_151200_h((JsonObject)obj2, (String)"op")) : part.getDefaultStatOperation(stat2);
                    String statId = String.format("mat_%s_%s%d", part.getId(), stat2.getName(), statMap.get(stat2).size() + 1);
                    statMap.put(stat2, new StatInstance(statId, value, op));
                }
                statMap.forEach((stat, instance) -> {
                    part.stats.removeAll(stat);
                    part.stats.put((ItemStat)stat, (StatInstance)instance);
                });
            }
            if ((elementTraits = json.get("traits")) != null && elementTraits.isJsonArray()) {
                JsonArray array = elementTraits.getAsJsonArray();
                HashMap<ITrait, Integer> traitsMap = new HashMap<ITrait, Integer>();
                for (JsonElement element : array) {
                    int level;
                    obj = element.getAsJsonObject();
                    String name = JsonUtils.func_151219_a((JsonObject)obj, (String)"name", (String)"");
                    ITrait trait = TraitManager.get(name);
                    if (trait == null || (level = MathHelper.func_76125_a((int)JsonUtils.func_151208_a((JsonObject)obj, (String)"level", (int)1), (int)1, (int)trait.getMaxLevel())) <= 0) continue;
                    traitsMap.put(trait, level);
                    SilentGear.LOGGER.debug("Add trait {} level {} to part {}", (Object)trait.getId(), (Object)level, (Object)part.getId());
                }
                if (!traitsMap.isEmpty()) {
                    part.traits.clear();
                    part.traits.putAll(traitsMap);
                }
            }
            if (!(craftingNormal = Serializer.getRequiredObj(craftingItems = Serializer.getRequiredObj(json, "crafting_items"), "normal")).has("item") && !craftingNormal.has("tag")) {
                throw new JsonParseException("crafting_items.normal must contain either 'item', 'tag', or both");
            }
            if (craftingNormal.has("item")) {
                ResourceLocation itemName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)craftingNormal, (String)"item"));
                part.materials.item = (IItemProvider)ForgeRegistries.ITEMS.getValue(itemName);
            }
            if (craftingNormal.has("tag")) {
                ResourceLocation tagName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)craftingNormal, (String)"tag"));
                part.materials.tag = ItemTags.func_199903_a().func_199915_b(tagName);
            }
            if ((craftingSmall = Serializer.getOptionalObj(craftingItems, "small")) != null) {
                if (!craftingSmall.has("item") && !craftingSmall.has("tag")) {
                    throw new JsonParseException("crafting_items.small must contain either 'item', 'tag', or both");
                }
                if (craftingSmall.has("item")) {
                    ResourceLocation itemName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)craftingSmall, (String)"item"));
                    part.materials.itemSmall = (IItemProvider)ForgeRegistries.ITEMS.getValue(itemName);
                }
                if (craftingSmall.has("tag")) {
                    ResourceLocation tagName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)craftingSmall, (String)"tag"));
                    part.materials.tagSmall = ItemTags.func_199903_a().func_199915_b(tagName);
                }
            }
            if ((elementName = json.get("name")) != null && elementName.isJsonObject()) {
                obj = elementName.getAsJsonObject();
                boolean translate = JsonUtils.func_151209_a((JsonObject)obj, (String)"translate", (boolean)false);
                String nameValue = JsonUtils.func_151200_h((JsonObject)obj, (String)"name");
                part.displayName = translate ? new TextComponentTranslation(nameValue, new Object[0]) : new TextComponentString(nameValue);
            } else if (elementName != null) {
                throw new JsonParseException("Expected 'name' to be an object");
            }
            JsonElement elementDisplay = json.get("textures");
            if (elementDisplay != null && elementDisplay.isJsonObject()) {
                JsonObject obj3 = elementDisplay.getAsJsonObject();
                PartDisplay defaultProps = part.display.getOrDefault("all", PartDisplay.DEFAULT);
                if (!part.display.containsKey("all")) {
                    part.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj3.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    JsonObject jsonObject = value.getAsJsonObject();
                    part.display.put(key, PartDisplay.from(jsonObject, defaultProps));
                }
            }
            if ((elementAvailability = json.get("availability")) != null && elementAvailability.isJsonObject()) {
                JsonObject obj4 = elementAvailability.getAsJsonObject();
                part.tier = JsonUtils.func_151208_a((JsonObject)obj4, (String)"tier", (int)part.tier);
            }
            return (T)part;
        }

        private static JsonObject getRequiredObj(JsonObject json, String name) {
            if (!json.has(name)) {
                throw new JsonParseException("Expected required object '" + name + "', found none");
            }
            JsonElement elem = json.get(name);
            if (!elem.isJsonObject()) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            return elem.getAsJsonObject();
        }

        @Nullable
        private static JsonObject getOptionalObj(JsonObject json, String name) {
            if (!json.has(name)) {
                return null;
            }
            JsonElement elem = json.get(name);
            if (!elem.isJsonObject()) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            return elem.getAsJsonObject();
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            part.displayName = buffer.func_179258_d();
            part.materials = PartMaterial.read(buffer);
            int displayCount = buffer.func_150792_a();
            for (int i = 0; i < displayCount; ++i) {
                String key = buffer.func_150789_c(255);
                PartDisplay display = PartDisplay.read(buffer);
                part.display.put(key, display);
            }
            part.stats = StatModifierMap.read(buffer);
            this.readTraits(buffer, part);
            return (T)part;
        }

        @Override
        public void write(PacketBuffer buffer, T part) {
            buffer.func_179256_a(((AbstractGearPart)part).getDisplayName(null, ItemStack.field_190927_a));
            ((AbstractGearPart)part).materials.write(buffer);
            buffer.func_150787_b(((AbstractGearPart)part).display.size());
            ((AbstractGearPart)part).display.forEach((s, partDisplay) -> {
                buffer.func_180714_a(s);
                PartDisplay.write(buffer, partDisplay);
            });
            ((AbstractGearPart)part).stats.write(buffer);
            this.writeTraits(buffer, part);
        }

        private void readTraits(PacketBuffer buffer, T part) {
            ((AbstractGearPart)part).traits.clear();
            int traitCount = buffer.func_150792_a();
            for (int i = 0; i < traitCount; ++i) {
                ResourceLocation traitId = buffer.func_192575_l();
                ITrait trait = TraitManager.get(traitId);
                byte level = buffer.readByte();
                if (trait != null) {
                    ((AbstractGearPart)part).traits.put(trait, Integer.valueOf(level));
                    continue;
                }
                SilentGear.LOGGER.warn("Read unknown trait from server: {}", (Object)traitId);
            }
        }

        private void writeTraits(PacketBuffer buffer, T part) {
            buffer.func_150787_b(((AbstractGearPart)part).traits.size());
            ((AbstractGearPart)part).traits.forEach((trait, level) -> {
                buffer.func_192572_a(trait.getId());
                buffer.writeByte(level.intValue());
            });
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }
    }
}

