/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartSerializers;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class PartManager
implements IResourceManagerReloadListener {
    public static final PartManager INSTANCE = new PartManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"PartManager");
    private static final Map<ResourceLocation, IGearPart> MAP = new LinkedHashMap<ResourceLocation, IGearPart>();
    private static final Map<IItemProvider, IGearPart> ITEM_TO_PART = new HashMap<IItemProvider, IGearPart>();
    private static int highestMainPartTier = 0;

    private PartManager() {
    }

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a("silentgear/parts", s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        ITEM_TO_PART.clear();
        SilentGear.LOGGER.info(MARKER, "Reloading part files");
        for (ResourceLocation id : resources) {
            try {
                IResource iresource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    String path = id.func_110623_a().substring("silentgear/parts/".length(), id.func_110623_a().length() - ".json".length());
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    SilentGear.LOGGER.debug(MARKER, "Found likely part file: {}, trying to read as part {}", (Object)id, (Object)name);
                    JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null) {
                        SilentGear.LOGGER.error(MARKER, "Could not load part {} as it's null or empty", (Object)name);
                        continue;
                    }
                    PartManager.addPart(PartSerializers.deserialize(name, json));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                SilentGear.LOGGER.error(MARKER, "Parsing error loading gear part {}", (Object)id, (Object)ex);
            }
            catch (IOException ex) {
                SilentGear.LOGGER.error(MARKER, "Could not read gear part {}", (Object)id, (Object)ex);
            }
        }
        SilentGear.LOGGER.info(MARKER, "Finished! Registered {} parts", (Object)MAP.size());
    }

    private static void addPart(IGearPart part) {
        if (MAP.containsKey(part.getId())) {
            throw new IllegalStateException("Duplicate gear part " + part.getId());
        }
        MAP.put(part.getId(), part);
    }

    public static Collection<IGearPart> getValues() {
        return MAP.values();
    }

    public static Collection<IGearPart> getPartsOfType(PartType type) {
        return PartManager.getValues().stream().filter(part -> part.getType() == type).collect(Collectors.toList());
    }

    public static Collection<IGearPart> getMains() {
        return PartManager.getPartsOfType(PartType.MAIN);
    }

    public static Collection<IGearPart> getRods() {
        return PartManager.getPartsOfType(PartType.ROD);
    }

    @Nullable
    public static IGearPart get(ResourceLocation id) {
        return MAP.get(id);
    }

    @Nullable
    public static IGearPart from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (ITEM_TO_PART.containsKey(item)) {
            return ITEM_TO_PART.get(item);
        }
        for (IGearPart part : MAP.values()) {
            if (!part.getMaterials().matches((IItemProvider)item)) continue;
            ITEM_TO_PART.put((IItemProvider)item, part);
            return part;
        }
        return null;
    }

    public static IGearPart tryGetFallback(PartType type) {
        ResourceLocation name = null;
        if (type == PartType.MAIN) {
            name = PartConst.FALLBACK_MAIN;
        } else if (type == PartType.ROD) {
            name = PartConst.FALLBACK_ROD;
        } else if (type == PartType.BOWSTRING) {
            name = PartConst.FALLBACK_BOWSTRING;
        }
        if (name == null) {
            throw new NullPointerException("Don't know fallback for part type '" + type + "'");
        }
        IGearPart part = PartManager.get(name);
        if (part == null) {
            throw new NullPointerException("Fallback part '" + name + "' was not found");
        }
        return part;
    }

    public static void handlePartSyncPacket(SyncGearPartsPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        packet.getParts().forEach(part -> MAP.put(part.getId(), (IGearPart)part));
        SilentGear.LOGGER.info("Read {} parts from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }
}

