/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IPartMaterial;

public class PartMaterial
implements IPartMaterial {
    IItemProvider item;
    IItemProvider itemSmall;
    Tag<Item> tag;
    Tag<Item> tagSmall;

    PartMaterial() {
    }

    @Override
    public boolean matches(IItemProvider input) {
        return this.item != null && this.item == input || this.tag != null && this.tag.func_199685_a_((Object)input.func_199767_j());
    }

    @Override
    @Nullable
    public IItemProvider getItem() {
        return this.item;
    }

    @Override
    @Nullable
    public IItemProvider getSmallItem() {
        return this.itemSmall;
    }

    @Override
    @Nullable
    public Tag<Item> getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Tag<Item> getSmallTag() {
        return this.tagSmall;
    }

    ItemStack getItemStack() {
        IItemProvider normal = this.item;
        return normal != null ? new ItemStack(normal) : ItemStack.field_190927_a;
    }

    ItemStack getSmallItemStack() {
        IItemProvider small = this.itemSmall;
        return small != null ? new ItemStack(small) : ItemStack.field_190927_a;
    }

    public static PartMaterial read(PacketBuffer buf) {
        PartMaterial material = new PartMaterial();
        material.item = PartMaterial.readItem(buf);
        material.itemSmall = PartMaterial.readItem(buf);
        material.tag = PartMaterial.readTag(buf);
        material.tagSmall = PartMaterial.readTag(buf);
        return material;
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.item != null ? this.item.func_199767_j().getRegistryName().toString() : "");
        buf.func_180714_a(this.itemSmall != null ? this.itemSmall.func_199767_j().getRegistryName().toString() : "");
        buf.func_180714_a(this.tag != null ? this.tag.func_199886_b().toString() : "");
        buf.func_180714_a(this.tagSmall != null ? this.tagSmall.func_199886_b().toString() : "");
    }

    @Nullable
    private static IItemProvider readItem(PacketBuffer buf) {
        String str = buf.func_150789_c(Short.MAX_VALUE);
        if (str.isEmpty()) {
            return null;
        }
        ResourceLocation id = ResourceLocation.func_208304_a((String)str);
        if (id == null) {
            SilentGear.LOGGER.warn("Received weird part material item string '{}' from server", (Object)str);
            return null;
        }
        return (IItemProvider)ForgeRegistries.ITEMS.getValue(id);
    }

    @Nullable
    private static Tag<Item> readTag(PacketBuffer buf) {
        String str = buf.func_150789_c(Short.MAX_VALUE);
        if (str.isEmpty()) {
            return null;
        }
        ResourceLocation id = ResourceLocation.func_208304_a((String)str);
        if (id == null) {
            SilentGear.LOGGER.warn("Received weird part material tag string '{}' from server", (Object)str);
            return null;
        }
        return ItemTags.func_199903_a().func_199915_b(id);
    }
}

