/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartType;

public final class PartSerializers {
    private static final Map<ResourceLocation, IPartSerializer<?>> REGISTRY = new HashMap();

    private PartSerializers() {
    }

    public static <S extends IPartSerializer<T>, T extends IGearPart> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate gear part serializer " + serializer.getName());
        }
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IGearPart deserialize(ResourceLocation id, JsonObject json) {
        ResourceLocation type;
        IPartSerializer<?> serializer;
        String typeStr = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!typeStr.contains(":")) {
            typeStr = "silentgear:" + typeStr;
        }
        if ((serializer = REGISTRY.get(type = new ResourceLocation(typeStr))) == null) {
            throw new JsonSyntaxException("Invalid or unsupported gear part type " + type);
        }
        return serializer.read(id, json);
    }

    public static IGearPart read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        IPartSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown gear part serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IGearPart> void write(T part, PacketBuffer buffer) {
        buffer.func_192572_a(part.getId());
        buffer.func_192572_a(part.getSerializer().getName());
        IPartSerializer<?> serializer = part.getSerializer();
        serializer.write(buffer, part);
    }

    static {
        for (PartType type : PartType.getValues()) {
            PartSerializers.register(type.getSerializer());
        }
    }
}

