/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.utils.MathUtils;

public final class DurabilityTrait
extends SimpleTrait {
    private static final ResourceLocation TRIGGER_BRITTLE = SilentGear.getId("brittle_proc");
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("durability_trait");
    static final ITraitSerializer<DurabilityTrait> SERIALIZER = new SimpleTrait.Serializer<DurabilityTrait>(SERIALIZER_ID, DurabilityTrait::new, DurabilityTrait::readJson);
    private float activationChance;
    private float effectScale;

    private DurabilityTrait(ResourceLocation id) {
        super(id);
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        EntityPlayer player = context.getPlayer();
        if (damageTaken != 0 && this.shouldActivate(context.getTraitLevel())) {
            if (this.effectScale > 0.0f && player instanceof EntityPlayerMP) {
                LibTriggers.GENERIC_INT.trigger((EntityPlayerMP)player, TRIGGER_BRITTLE, 1);
            }
            return Math.round((float)damageTaken + this.effectScale);
        }
        return super.onDurabilityDamage(context, damageTaken);
    }

    private boolean shouldActivate(int level) {
        return MathUtils.tryPercentage((double)(this.activationChance * (float)level));
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static void readJson(DurabilityTrait trait, JsonObject json) {
        trait.activationChance = JsonUtils.func_151221_a((JsonObject)json, (String)"activation_chance", (float)1.0f);
        trait.effectScale = JsonUtils.func_151208_a((JsonObject)json, (String)"effect_scale", (int)0);
    }
}

