/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.TimeUtils;

public final class PotionEffectTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("potion_effect_trait");
    static final ITraitSerializer<PotionEffectTrait> SERIALIZER = new SimpleTrait.Serializer<PotionEffectTrait>(SERIALIZER_ID, PotionEffectTrait::new, PotionEffectTrait::readJson);
    private final Map<String, List<PotionData>> potions = new HashMap<String, List<PotionData>>();

    private PotionEffectTrait(ResourceLocation id) {
        super(id);
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        EntityPlayer player = context.getPlayer();
        if (player == null || !isEquipped) {
            return;
        }
        GearType gearType = ((ICoreItem)context.getGear().func_77973_b()).getGearType();
        this.potions.forEach((type, list) -> this.applyEffects(player, gearType, (String)type, (Iterable<PotionData>)list));
    }

    private void applyEffects(EntityPlayer player, GearType gearType, String type, Iterable<PotionData> effects) {
        if (gearType.matches(type) || "all".equals(type)) {
            int setPieceCount = this.getSetPieceCount(type, player);
            boolean hasFullSet = !"armor".equals(type) || setPieceCount >= 4;
            effects.forEach(d -> d.getEffect(setPieceCount, hasFullSet).ifPresent(arg_0 -> ((EntityPlayer)player).func_195064_c(arg_0)));
        }
    }

    private int getSetPieceCount(String type, EntityPlayer player) {
        if (!"armor".equals(type)) {
            return 1;
        }
        int count = 0;
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ICoreArmor) || TraitHelper.getTraitLevel(stack, this) <= 0) continue;
            ++count;
        }
        return count;
    }

    private static void readJson(PotionEffectTrait trait, JsonObject json) {
        if (!json.has("potion_effects")) {
            throw new JsonParseException("Potion effect trait '" + trait.getId() + "' is missing 'potion_effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("potion_effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(PotionData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.potions.put(key, list);
        }
    }

    public static class PotionData {
        private boolean requiresFullSet;
        private ResourceLocation effectId;
        private int duration;
        private int[] levels;

        static PotionData from(JsonObject json) {
            PotionData ret = new PotionData();
            ret.requiresFullSet = JsonUtils.func_151209_a((JsonObject)json, (String)"full_set", (boolean)false);
            ret.effectId = new ResourceLocation(JsonUtils.func_151219_a((JsonObject)json, (String)"effect", (String)"unknown"));
            float durationInSeconds = JsonUtils.func_151221_a((JsonObject)json, (String)"duration", (float)PotionData.getDefaultDuration(ret));
            ret.duration = TimeUtils.ticksFromSeconds((float)durationInSeconds);
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{JsonUtils.func_151208_a((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        private static float getDefaultDuration(PotionData ret) {
            return "night_vision".equals(ret.effectId.func_110623_a()) ? 15.5f : 1.5f;
        }

        Optional<PotionEffect> getEffect(int pieceCount, boolean hasFullSet) {
            if (this.requiresFullSet && !hasFullSet) {
                return Optional.empty();
            }
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(this.effectId);
            if (potion == null) {
                return Optional.empty();
            }
            int effectLevel = this.levels[MathHelper.func_76125_a((int)(pieceCount - 1), (int)0, (int)(this.levels.length - 1))];
            if (effectLevel < 1) {
                return Optional.empty();
            }
            return Optional.of(new PotionEffect(potion, this.duration, effectLevel - 1, true, false));
        }
    }
}

