/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;

public class SimpleTrait
implements ITrait {
    public static final Serializer<SimpleTrait> SERIALIZER = new Serializer<SimpleTrait>(Serializer.access$000(), SimpleTrait::new);
    private final ResourceLocation objId;
    int maxLevel;
    Set<String> cancelsWith = new HashSet<String>();
    ITextComponent displayName;
    ITextComponent description;

    public SimpleTrait(ResourceLocation id) {
        this.objId = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.objId;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public boolean willCancelWith(ITrait other) {
        return this.cancelsWith.contains(other.getId().toString());
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        return this.displayName.func_212638_h().func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation("enchantment.level." + level, new Object[0]));
    }

    @Override
    public ITextComponent getDescription(int level) {
        return this.description.func_212638_h();
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public float onAttackEntity(TraitActionContext context, EntityLivingBase target, float baseValue) {
        return baseValue;
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        return damageTaken;
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        return value;
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
    }

    public static final class Serializer<T extends SimpleTrait>
    implements ITraitSerializer<T> {
        private static final ResourceLocation NAME = new ResourceLocation("silentgear", "simple_trait");
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> factory;
        private final BiConsumer<T, JsonObject> readJson;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory) {
            this(serializerId, factory, null);
        }

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory, @Nullable BiConsumer<T, JsonObject> readJson) {
            this.serializerId = serializerId;
            this.factory = factory;
            this.readJson = readJson;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = JsonUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)1);
            trait.displayName = Serializer.readTextComponent(json, "name");
            trait.description = Serializer.readTextComponent(json, "description");
            if (json.has("cancels_with")) {
                JsonArray array = json.getAsJsonArray("cancels_with");
                for (JsonElement elem : array) {
                    trait.cancelsWith.add(elem.getAsString());
                }
            }
            if (this.readJson != null) {
                this.readJson.accept(trait, json);
            }
            return (T)trait;
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = buffer.readByte();
            trait.displayName = buffer.func_179258_d();
            trait.description = buffer.func_179258_d();
            int cancelsCount = buffer.func_150792_a();
            for (int i = 0; i < cancelsCount; ++i) {
                trait.cancelsWith.add(buffer.func_150789_c(255));
            }
            return (T)trait;
        }

        @Override
        public void write(PacketBuffer buffer, T trait) {
            buffer.writeByte(((SimpleTrait)trait).maxLevel);
            buffer.func_179256_a(((SimpleTrait)trait).displayName);
            buffer.func_179256_a(((SimpleTrait)trait).description);
            buffer.func_150787_b(((SimpleTrait)trait).cancelsWith.size());
            for (String str : ((SimpleTrait)trait).cancelsWith) {
                buffer.func_180714_a(str);
            }
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }

        private static ITextComponent readTextComponent(JsonObject json, String name) {
            JsonElement element = json.get(name);
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                boolean translate = JsonUtils.func_151209_a((JsonObject)obj, (String)"translate", (boolean)false);
                String value = JsonUtils.func_151200_h((JsonObject)obj, (String)"name");
                return translate ? new TextComponentTranslation(value, new Object[0]) : new TextComponentString(value);
            }
            if (element != null) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            throw new JsonParseException("Missing required object '" + name + "'");
        }

        static /* synthetic */ ResourceLocation access$000() {
            return NAME;
        }
    }
}

