/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;

public final class StatModifierTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("stat_modifier_trait");
    static final ITraitSerializer<StatModifierTrait> SERIALIZER = new SimpleTrait.Serializer<StatModifierTrait>(SERIALIZER_ID, StatModifierTrait::new, StatModifierTrait::readJson);
    private final Map<ItemStat, StatMod> mods = new HashMap<ItemStat, StatMod>();

    private StatModifierTrait(ResourceLocation name) {
        super(name);
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        StatMod mod = this.mods.get(stat);
        if (mod != null) {
            return mod.apply(context.getTraitLevel(), value, damageRatio);
        }
        return value;
    }

    private static void readJson(StatModifierTrait trait, JsonObject json) {
        if (!json.has("stats")) {
            SilentGear.LOGGER.error("JSON file for StatModifierTrait '{}' is missing the 'stats' array", (Object)trait.getId());
            return;
        }
        for (JsonElement element : json.get("stats").getAsJsonArray()) {
            JsonObject obj;
            String statName;
            ItemStat stat;
            if (!element.isJsonObject() || (stat = ItemStat.ALL_STATS.get(statName = JsonUtils.func_151219_a((JsonObject)(obj = element.getAsJsonObject()), (String)"name", (String)""))) == null) continue;
            trait.mods.put(stat, StatMod.fromJson(obj));
        }
    }

    private static class StatMod {
        private float multi;
        private boolean factorDamage;
        private boolean factorValue;

        private StatMod() {
        }

        private float apply(int level, float value, float damageRatio) {
            float f = this.multi * (float)level;
            if (this.factorDamage) {
                f *= damageRatio;
            }
            if (this.factorValue) {
                f *= value;
            }
            return value + f;
        }

        private static StatMod fromJson(JsonObject json) {
            StatMod mod = new StatMod();
            mod.multi = JsonUtils.func_151221_a((JsonObject)json, (String)"value", (float)0.0f);
            mod.factorDamage = JsonUtils.func_151209_a((JsonObject)json, (String)"factor_damage", (boolean)true);
            mod.factorValue = JsonUtils.func_151209_a((JsonObject)json, (String)"factor_value", (boolean)true);
            return mod;
        }
    }
}

