/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.network.SyncTraitsPacket;
import net.silentchaos512.gear.traits.TraitSerializers;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class TraitManager
implements IResourceManagerReloadListener {
    public static final TraitManager INSTANCE = new TraitManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"TraitManager");
    private static final String DATA_PATH = "silentgear/traits/";
    private static final Map<ResourceLocation, ITrait> MAP = new LinkedHashMap<ResourceLocation, ITrait>();

    private TraitManager() {
    }

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        SilentGear.LOGGER.info(MARKER, "Reloading trait files");
        for (ResourceLocation id : resources) {
            try {
                IResource iresource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    String path = id.func_110623_a().substring(DATA_PATH.length(), id.func_110623_a().length() - ".json".length());
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    SilentGear.LOGGER.debug(MARKER, "Found likely trait file: {}, trying to read as trait {}", (Object)id, (Object)name);
                    JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null) {
                        SilentGear.LOGGER.error(MARKER, "could not load trait {} as it's null or empty", (Object)name);
                        continue;
                    }
                    TraitManager.addTrait(TraitSerializers.deserialize(name, json));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                SilentGear.LOGGER.error(MARKER, "Parsing error loading trait {}", (Object)id, (Object)ex);
            }
            catch (IOException ex) {
                SilentGear.LOGGER.error(MARKER, "Could not read trait {}", (Object)id, (Object)ex);
            }
        }
        SilentGear.LOGGER.info(MARKER, "Finished! Registered {} traits", (Object)MAP.size());
    }

    private static void addTrait(ITrait trait) {
        if (MAP.containsKey(trait.getId())) {
            throw new IllegalArgumentException("Duplicate trait " + trait.getId());
        }
        MAP.put(trait.getId(), trait);
    }

    public static Collection<ITrait> getValues() {
        return MAP.values();
    }

    @Nullable
    public static ITrait get(ResourceLocation id) {
        return MAP.get(id);
    }

    @Nullable
    public static ITrait get(String strId) {
        return TraitManager.get(new ResourceLocation(strId));
    }

    public static void handleTraitSyncPacket(SyncTraitsPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        packet.getTraits().forEach(trait -> MAP.put(trait.getId(), (ITrait)trait));
        SilentGear.LOGGER.info("Read {} traits from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }
}

