/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.traits.DamageTypeTrait;
import net.silentchaos512.gear.traits.DurabilityTrait;
import net.silentchaos512.gear.traits.EnchantmentTrait;
import net.silentchaos512.gear.traits.PotionEffectTrait;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.traits.StatModifierTrait;

public final class TraitSerializers {
    private static final Map<ResourceLocation, ITraitSerializer<?>> REGISTRY = new HashMap();

    private TraitSerializers() {
    }

    public static <S extends ITraitSerializer<T>, T extends ITrait> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate trait serializer " + serializer.getName());
        }
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static ITrait deserialize(ResourceLocation id, JsonObject json) {
        ResourceLocation type;
        ITraitSerializer<?> serializer;
        String typeStr = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!typeStr.contains(":")) {
            typeStr = "silentgear:" + typeStr;
        }
        if ((serializer = REGISTRY.get(type = new ResourceLocation(typeStr))) == null) {
            throw new JsonParseException("Invalid or unsupported trait type " + type);
        }
        return serializer.read(id, json);
    }

    public static ITrait read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        ITraitSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown trait serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends ITrait> void write(T trait, PacketBuffer buffer) {
        buffer.func_192572_a(trait.getId());
        buffer.func_192572_a(trait.getSerializer().getName());
        ITraitSerializer<?> serializer = trait.getSerializer();
        serializer.write(buffer, trait);
    }

    static {
        TraitSerializers.register(SimpleTrait.SERIALIZER);
        TraitSerializers.register(DamageTypeTrait.SERIALIZER);
        TraitSerializers.register(DurabilityTrait.SERIALIZER);
        TraitSerializers.register(EnchantmentTrait.SERIALIZER);
        TraitSerializers.register(PotionEffectTrait.SERIALIZER);
        TraitSerializers.register(StatModifierTrait.SERIALIZER);
    }
}

