/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.PartHighlight;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.gear.parts.type.PartRod;
import net.silentchaos512.gear.parts.type.PartTip;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.collection.StackList;

public final class GearData {
    private static final String NBT_ROOT = "SGear_Data";
    private static final String NBT_ROOT_CONSTRUCTION = "Construction";
    private static final String NBT_ROOT_PROPERTIES = "Properties";
    private static final String NBT_ROOT_MODEL_KEYS = "ModelKeys";
    private static final String NBT_ROOT_STATISTICS = "Statistics";
    private static final String NBT_CONSTRUCTION_PARTS = "Parts";
    private static final String NBT_LOCK_STATS = "LockStats";
    private static final String NBT_IS_EXAMPLE = "IsExample";
    private static final String NBT_RANDOM_GRADING_DONE = "RandomGradingDone";
    private static final String NBT_SYNERGY_DISPLAY = "synergy";
    private static final String NBT_UUID = "SGear_UUID";
    private static final String NBT_BROKEN_COUNT = "BrokenCount";
    private static final String NBT_REPAIR_COUNT = "RepairCount";
    private static final int MAX_MAIN_PARTS = 9;
    private static final int MAX_ROD_PARTS = 1;
    private static final int MAX_TIP_PARTS = 1;
    private static final double SYNERGY_MULTI = 1.1;

    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    public static void recalculateStats(EntityPlayer player, ItemStack stack) {
        boolean partsListValid;
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called recalculateStats on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        GearData.getUUID(stack);
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        PartDataList parts = GearData.getConstructionParts(stack);
        NBTTagCompound propertiesCompound = GearData.getData(stack, NBT_ROOT_PROPERTIES);
        if (!propertiesCompound.func_74764_b(NBT_LOCK_STATS)) {
            propertiesCompound.func_74757_a(NBT_LOCK_STATS, false);
        }
        boolean statsUnlocked = !propertiesCompound.func_74767_n(NBT_LOCK_STATS);
        boolean bl = partsListValid = !parts.isEmpty() && !parts.getMains().isEmpty();
        if (statsUnlocked && partsListValid) {
            GearData.addOrRemoveHighlightPart(stack, parts);
            PartDataList uniqueParts = parts.getUniqueParts(true);
            Map<ITrait, Integer> traits = TraitHelper.getTraits(stack, parts);
            double synergy = GearData.calculateSynergyValue(parts, uniqueParts, traits);
            boolean hasMissingRod = item instanceof ICoreTool && parts.getRods().isEmpty();
            Multimap<ItemStat, StatInstance> stats = GearData.getStatModifiers(stack, item, parts, synergy);
            float damageRatio = (float)stack.func_77952_i() / (float)stack.func_77958_k();
            for (ItemStat stat : stats.keySet()) {
                float initialValue = stat.compute(0.0f, stats.get((Object)stat));
                float withMissingParts = hasMissingRod ? stat.withMissingRodEffect(initialValue) : initialValue;
                float value = TraitHelper.activateTraits(stack, withMissingParts, (trait, level, val) -> trait.onGetStat(new TraitActionContext(player, level, stack), stat, val, damageRatio));
                propertiesCompound.func_74776_a(stat.getName().func_110623_a(), value);
            }
            NBTTagList traitList = new NBTTagList();
            for (ITrait trait2 : traits.keySet()) {
                int level2 = traits.get(trait2);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Name", trait2.getId().toString());
                tag.func_74774_a("Level", (byte)level2);
                traitList.add((INBTBase)tag);
            }
            propertiesCompound.func_74782_a("Traits", (INBTBase)traitList);
            propertiesCompound.func_74776_a(NBT_SYNERGY_DISPLAY, (float)synergy);
        }
        GearData.createAndSaveModelKeys(stack, item, parts);
    }

    private static void addOrRemoveHighlightPart(ItemStack stack, PartDataList parts) {
        PartData primary = parts.getPrimaryMain();
        if (primary == null) {
            return;
        }
        boolean changed = false;
        if (primary.getPart().getDisplayProperties(primary, stack, 0).hasHighlight()) {
            if (parts.getParts(p -> p.getPart() instanceof PartHighlight).isEmpty()) {
                IGearPart highlight = PartManager.get(new ResourceLocation("silentgear", "highlight"));
                if (highlight != null) {
                    parts.add(PartData.of(highlight));
                    changed = true;
                } else {
                    SilentGear.LOGGER.error("GearData#addOrRemoveHighlightPart: highlight part is missing?");
                }
            }
        } else {
            changed = parts.removeIf(p -> p.getPart() instanceof PartHighlight);
        }
        if (changed) {
            GearData.writeConstructionParts(stack, parts);
        }
    }

    @Deprecated
    public static void recalculateStats(ItemStack stack) {
        GearData.recalculateStats(null, stack);
    }

    private static void createAndSaveModelKeys(ItemStack stack, ICoreItem item, PartDataList parts) {
        stack.func_190925_c(NBT_ROOT).func_82580_o(NBT_ROOT_MODEL_KEYS);
        NBTTagCompound modelKeys = GearData.getData(stack, NBT_ROOT_MODEL_KEYS);
        for (int i = 0; i < item.getAnimationFrames(); ++i) {
            modelKeys.func_74778_a(Integer.toString(i), item.getModelKey(stack, i, parts.toArray(new PartData[0])));
        }
    }

    public static String getCachedModelKey(ItemStack stack, int animationFrame) {
        String key;
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return "Invalid item!";
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_MODEL_KEYS);
        if (!tags.func_74764_b(key = Integer.toString(animationFrame))) {
            tags.func_74778_a(key, ((ICoreItem)stack.func_77973_b()).getModelKey(stack, animationFrame));
        }
        return tags.func_74779_i(Integer.toString(animationFrame));
    }

    public static Multimap<ItemStat, StatInstance> getStatModifiers(ItemStack stack, @Nullable ICoreItem item, PartDataList parts, double synergy) {
        StatModifierMap stats = new StatModifierMap();
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            if (item != null) {
                item.getBaseStatModifier(stat).ifPresent(mod -> stats.put(stat, mod));
                item.getStatModifier(stat).ifPresent(mod -> stats.put(stat, mod));
            }
            int partCount = 0;
            for (PartData partData : parts) {
                String idSuffix = "_" + ++partCount;
                for (StatInstance inst : partData.getStatModifiers(stack, stat)) {
                    if (inst.getOp() == StatInstance.Operation.AVG && stat.isAffectedByGrades()) {
                        float gradeBonus = 1.0f + (float)partData.getGrade().bonusPercent / 100.0f;
                        float statValue = inst.getValue() * gradeBonus;
                        stats.put(stat, new StatInstance(inst.getId() + idSuffix, statValue, StatInstance.Operation.AVG));
                        continue;
                    }
                    stats.put(stat, inst.copyAppendId(idSuffix));
                }
            }
            if (!stat.doesSynergyApply()) continue;
            stats.put(stat, new StatInstance("synergy_multi", (float)synergy - 1.0f, StatInstance.Operation.MUL2));
        }
        return stats;
    }

    private static double getBaseSynergy(PartDataList parts) {
        int x = parts.getMains().size();
        double a = 1.1;
        return 1.1 * ((double)x / ((double)x + 1.1)) + 0.47619047619047616;
    }

    public static double calculateSynergyValue(PartDataList parts, PartDataList uniqueParts, Map<ITrait, Integer> traits) {
        ITrait crude;
        float primaryRarity;
        double synergy = GearData.getBaseSynergy(uniqueParts);
        PartData primaryMain = parts.getPrimaryMain();
        float maxRarity = primaryRarity = primaryMain == null ? 0.0f : primaryMain.computeStat(CommonItemStats.RARITY);
        int maxTier = 0;
        for (PartData data : uniqueParts) {
            maxRarity = Math.max(maxRarity, data.computeStat(CommonItemStats.RARITY));
            maxTier = Math.max(maxTier, data.getPart().getTier());
        }
        for (PartData data : uniqueParts) {
            if (maxRarity > 0.0f) {
                float rarity = data.computeStat(CommonItemStats.RARITY);
                synergy -= 0.005 * (double)Math.abs(primaryRarity - rarity);
            }
            if (maxTier <= 0) continue;
            int tier = data.getPart().getTier();
            synergy -= (double)(0.16f * (float)Math.abs(maxTier - tier));
        }
        ITrait synergistic = TraitManager.get(TraitConst.SYNERGISTIC);
        if (synergy > 1.0 && traits.containsKey(synergistic)) {
            int level = traits.get(synergistic);
            synergy += (double)((float)level * 0.04f);
        }
        if (traits.containsKey(crude = TraitManager.get(TraitConst.CRUDE))) {
            int level = traits.get(crude);
            synergy -= (double)((float)level * 0.04f);
        }
        return synergy;
    }

    public static float getStat(ItemStack stack, ItemStat stat) {
        String key;
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getStat on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return stat.getDefaultValue();
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_PROPERTIES);
        if (tags.func_74764_b(key = stat.getName().func_110623_a())) {
            return tags.func_74760_g(key);
        }
        return stat.getDefaultValue();
    }

    public static int getStatInt(ItemStack stack, ItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public static boolean hasLockedStats(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called hasLockedStats on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return false;
        }
        return GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74767_n(NBT_LOCK_STATS);
    }

    public static void setLockedStats(ItemStack stack, boolean lock) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called setLockedStats on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74757_a(NBT_LOCK_STATS, lock);
    }

    public static PartDataList getConstructionParts(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getConstructionParts on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return PartDataList.of(new PartData[0]);
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        PartDataList list = PartDataList.of(new PartData[0]);
        int mainsFound = 0;
        int rodsFound = 0;
        int tipsFound = 0;
        for (INBTBase nbt : tagList) {
            NBTTagCompound partCompound;
            PartData data;
            if (!(nbt instanceof NBTTagCompound) || (data = PartData.read(partCompound = (NBTTagCompound)nbt)) == null) continue;
            if (data.getPart() instanceof PartMain && ++mainsFound <= 9) {
                list.add(data);
                continue;
            }
            if (data.getPart() instanceof PartRod && ++rodsFound <= 1) {
                list.add(data);
                continue;
            }
            if (data.getPart() instanceof PartTip && ++tipsFound <= 1) {
                list.add(data);
                continue;
            }
            list.add(data);
        }
        return list;
    }

    public static float getSynergyDisplayValue(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called recalculateStats on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return 1.0f;
        }
        return GearData.getData(gear, NBT_ROOT_PROPERTIES).func_74760_g(NBT_SYNERGY_DISPLAY);
    }

    @Nullable
    public static PartData getPrimaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 0);
    }

    @Nullable
    public static PartData getSecondaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 1);
    }

    @Nullable
    public static PartData getPrimaryRenderPartFast(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getPrimaryRenderPartFast on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return null;
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        INBTBase nbt = tagList.get(0);
        if (nbt instanceof NBTTagCompound) {
            return PartData.readFast((NBTTagCompound)nbt);
        }
        return null;
    }

    @Nullable
    private static PartData getPartByIndex(ItemStack stack, int index) {
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        INBTBase nbt = tagList.get(index);
        if (nbt instanceof NBTTagEnd) {
            return null;
        }
        PartData data = PartData.readFast((NBTTagCompound)nbt);
        return data != null && data.getType() == PartType.MAIN ? data : null;
    }

    @Nullable
    public static PartData getPartOfType(ItemStack stack, PartType type) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getPartOfType on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return null;
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (INBTBase nbt : tagList) {
            PartData part;
            if (!(nbt instanceof NBTTagCompound) || (part = PartData.readFast((NBTTagCompound)nbt)) == null || part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOftype(ItemStack stack, PartType type) {
        if (!GearHelper.isGear(stack)) {
            return false;
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (INBTBase nbt : tagList) {
            PartData part;
            if (!(nbt instanceof NBTTagCompound) || (part = PartData.readFast((NBTTagCompound)nbt)) == null || part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void addUpgradePart(ItemStack gear, ItemStack partStack) {
        PartData part = PartData.from(partStack);
        if (part != null) {
            GearData.addUpgradePart(gear, part);
        }
    }

    public static void addUpgradePart(ItemStack gear, PartData part) {
        if (!(gear.func_77973_b() instanceof ICoreItem)) {
            SilentGear.LOGGER.error("Tried to add upgrade part to non-gear item {}", (Object)gear);
            throw new IllegalArgumentException("Invalid Item type");
        }
        PartDataList parts = GearData.getConstructionParts(gear);
        if (part.getPart() instanceof IUpgradePart) {
            IUpgradePart upgradePart = (IUpgradePart)((Object)part.getPart());
            if (!upgradePart.isValidFor((ICoreItem)gear.func_77973_b())) {
                return;
            }
            if (upgradePart.replacesExisting()) {
                parts.removeIf(p -> p.getPart().getPartPosition() == part.getPart().getPartPosition());
            }
        }
        for (PartData partInList : parts) {
            if (partInList.getPart() != part.getPart()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, ResourceLocation partId) {
        IGearPart part = PartManager.get(partId);
        if (part == null) {
            return false;
        }
        return GearData.hasPart(gear, part);
    }

    public static boolean hasPart(ItemStack gear, IGearPart upgrade) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called hasPart on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return false;
        }
        NBTTagCompound tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        String upgradeName = upgrade.getId().toString();
        for (INBTBase nbt : tagList) {
            NBTTagCompound partCompound;
            String partKey;
            if (!(nbt instanceof NBTTagCompound) || !(partKey = (partCompound = (NBTTagCompound)nbt).func_74779_i("ID")).equals(upgradeName)) continue;
            return true;
        }
        return false;
    }

    public static void writeConstructionParts(ItemStack stack, Collection<PartData> parts) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called writeConstructionParts on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = new NBTTagList();
        parts.stream().filter(p -> p.getType() == PartType.MAIN).map(p -> p.write(new NBTTagCompound())).forEach(arg_0 -> ((NBTTagList)tagList).add(arg_0));
        parts.stream().filter(p -> p.getType() != PartType.MAIN).map(p -> p.write(new NBTTagCompound())).forEach(arg_0 -> ((NBTTagList)tagList).add(arg_0));
        tags.func_74782_a(NBT_CONSTRUCTION_PARTS, (INBTBase)tagList);
    }

    public static UUID getUUID(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called getUUID on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return null;
        }
        NBTTagCompound tags = gear.func_196082_o();
        if (!tags.func_186855_b(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tags.func_186854_a(NBT_UUID, uuid);
            return uuid;
        }
        return tags.func_186857_a(NBT_UUID);
    }

    private static NBTTagCompound getData(ItemStack stack, String compoundKey) {
        NBTTagCompound rootTag;
        if (SilentGear.isDevBuild() && !GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getData on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
        }
        if (!(rootTag = stack.func_190925_c(NBT_ROOT)).func_74764_b(compoundKey)) {
            rootTag.func_74782_a(compoundKey, (INBTBase)new NBTTagCompound());
        }
        return rootTag.func_74775_l(compoundKey);
    }

    static NBTTagCompound getPropertiesData(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES);
    }

    static NBTTagCompound getStatisticsCompound(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_STATISTICS);
    }

    static void setExampleTag(ItemStack stack, boolean value) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called setExampleTag on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_IS_EXAMPLE, value);
    }

    public static boolean isExampleGear(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called isExampleGear on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return false;
        }
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_IS_EXAMPLE);
    }

    public static boolean isRandomGradingDone(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called isRandomGradingDone on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return true;
        }
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_RANDOM_GRADING_DONE);
    }

    static void setRandomGradingDone(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_RANDOM_GRADING_DONE, value);
    }

    public static int getBrokenCount(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getBrokenCount on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return 0;
        }
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_BROKEN_COUNT);
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_BROKEN_COUNT, GearData.getBrokenCount(stack) + 1);
    }

    public static int getRepairCount(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getRepairCount on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return 0;
        }
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_REPAIR_COUNT);
    }

    public static void incrementRepairCount(ItemStack stack, int amount) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called incrementRepairCount on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_REPAIR_COUNT, GearData.getRepairCount(stack) + amount);
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayer player = event.getPlayer();
            StackList.from((IInventory)player.field_71071_by).stream().filter(s -> s.func_77973_b() instanceof ICoreItem).forEach(s -> GearData.recalculateStats(player, s));
        }
    }
}

