/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.PartBowstring;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.gear.parts.type.PartRod;
import net.silentchaos512.gear.parts.type.PartTip;
import net.silentchaos512.gear.util.GearData;

public final class GearGenerator {
    private GearGenerator() {
    }

    public static List<? extends IGearPart> getPartsOfType(Class<? extends IGearPart> partClass) {
        return GearGenerator.getPartsOfType(partClass::isInstance);
    }

    public static List<? extends IGearPart> getPartsOfType(Class<? extends IGearPart> partClass, int partTier) {
        return GearGenerator.getPartsOfType((? super IGearPart part) -> partClass.isInstance(part) && (partTier < 0 || part.getTier() == partTier));
    }

    public static List<? extends IGearPart> getPartsOfType(Predicate<? super IGearPart> condition) {
        return PartManager.getValues().stream().filter(condition).collect(Collectors.toList());
    }

    public static Optional<IGearPart> selectRandom(Class<? extends IGearPart> partClass) {
        return GearGenerator.selectRandom(partClass, -1);
    }

    public static Optional<IGearPart> selectRandom(Class<? extends IGearPart> partClass, int partTier) {
        List<? extends IGearPart> list = GearGenerator.getPartsOfType(partClass, partTier);
        if (!list.isEmpty()) {
            return Optional.of(list.get(SilentGear.random.nextInt(list.size())));
        }
        IGearPart fallback = GearGenerator.getFallback(partClass);
        return fallback == null ? Optional.empty() : Optional.of(fallback);
    }

    @Nullable
    private static IGearPart getFallback(Class<? extends IGearPart> partClass) {
        SilentGear.LOGGER.debug("GearGenerator::getFallback: class {}", partClass);
        if (partClass == PartRod.class) {
            return PartManager.get(PartConst.FALLBACK_ROD);
        }
        if (partClass == PartBowstring.class) {
            return GearGenerator.selectRandom(partClass, -1).orElse(PartManager.get(PartConst.FALLBACK_BOWSTRING));
        }
        SilentGear.LOGGER.debug("    no fallback part available");
        return null;
    }

    public static ItemStack create(ICoreItem item, int minTier, int maxTier) {
        if (minTier >= maxTier) {
            return GearGenerator.create(item, maxTier);
        }
        return GearGenerator.create(item, minTier + SilentGear.random.nextInt(maxTier - minTier));
    }

    public static ItemStack create(ICoreItem item, int tier) {
        Optional<IGearPart> main = GearGenerator.selectRandom(PartMain.class, tier);
        Optional<IGearPart> rod = GearGenerator.selectRandom(PartRod.class, tier);
        if (!main.isPresent() || !rod.isPresent()) {
            SilentGear.LOGGER.warn("Could not create {} of tier {}", (Object)item.getGearType().getName(), (Object)tier);
            return ItemStack.field_190927_a;
        }
        PartDataList parts = PartDataList.of(new PartData[0]);
        for (int i = 0; i < 1; ++i) {
            parts.addPart(main.get());
        }
        if (item.requiresPartOfType(PartType.ROD)) {
            parts.addPart(rod.get());
        }
        if (item.requiresPartOfType(PartType.BOWSTRING)) {
            Optional<IGearPart> bowstring = GearGenerator.selectRandom(PartBowstring.class, tier);
            bowstring.ifPresent(parts::addPart);
        }
        ItemStack result = item.construct(parts);
        if (item instanceof ICoreTool && SilentGear.random.nextFloat() < 0.2f * (float)tier + 0.1f) {
            Optional<IGearPart> tip = GearGenerator.selectRandom(PartTip.class);
            tip.ifPresent(part -> GearData.addUpgradePart(result, PartData.of(part)));
        }
        GearData.recalculateStats(null, result);
        return result;
    }
}

