/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.MiscUpgrades;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;

public final class GearHelper {
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("5e889b20-a8bd-43df-9ece-88a9f9be7530");
    private static final float BROKEN_ATTACK_SPEED_CHANGE = 0.7f;
    private static final float BROKEN_DESTROY_SPEED = 0.25f;
    private static final int DAMAGE_FACTOR_LEVELS = 10;
    private static final Map<GearType, List<ItemStack>> subItemCache = new HashMap<GearType, List<ItemStack>>();

    private GearHelper() {
    }

    public static boolean isGear(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem;
    }

    public static float getMeleeDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 1.0f;
        }
        float val = GearData.getStat(stack, CommonItemStats.MELEE_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMagicDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float val = GearData.getStat(stack, CommonItemStats.MAGIC_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getAttackSpeedModifier(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICoreTool)) {
            return 0.0f;
        }
        float speed = GearData.getStat(stack, CommonItemStats.ATTACK_SPEED);
        if (GearHelper.isBroken(stack)) {
            speed += 0.7f;
        }
        return speed;
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap map = stack.func_77973_b().func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            String key = SharedMonsterAttributes.field_111264_e.func_111108_a();
            float value = GearHelper.getMeleeDamageModifier(stack);
            GearHelper.replaceAttributeModifierInMap((Multimap<String, AttributeModifier>)map, key, value);
            key = SharedMonsterAttributes.field_188790_f.func_111108_a();
            value = GearHelper.getAttackSpeedModifier(stack);
            GearHelper.replaceAttributeModifierInMap((Multimap<String, AttributeModifier>)map, key, value);
            map.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_MODIFIER_UUID, "Gear reach", (double)GearData.getStat(stack, CommonItemStats.REACH_DISTANCE), 0));
        }
        return map;
    }

    private static void replaceAttributeModifierInMap(Multimap<String, AttributeModifier> map, String key, float value) {
        Iterator iter;
        if (map.containsKey((Object)key) && (iter = map.get((Object)key).iterator()).hasNext()) {
            AttributeModifier mod = (AttributeModifier)iter.next();
            map.removeAll((Object)key);
            map.put((Object)key, (Object)new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), (double)value, mod.func_111169_c()));
        }
    }

    public static boolean getIsRepairable(ItemStack stack, ItemStack material) {
        PartData data = GearData.getPrimaryPart(stack);
        PartData dataMaterial = PartData.from(material);
        return data != null && dataMaterial != null && data.getTier() <= dataMaterial.getTier();
    }

    public static void attemptDamage(ItemStack stack, int amount, EntityLivingBase entityLiving) {
        if (GearHelper.isUnbreakable(stack) || entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            return;
        }
        boolean canBreakPermanently = GearHelper.canBreakPermanently(stack);
        EntityPlayerMP player = entityLiving instanceof EntityPlayerMP ? (EntityPlayerMP)entityLiving : null;
        int preTraitAmount = amount;
        amount = (int)TraitHelper.activateTraits(stack, preTraitAmount, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext((EntityPlayer)player, level, stack), (int)val));
        int maxDamage = stack.func_77958_k();
        int preDamageFactor = GearHelper.getDamageFactor(stack, maxDamage);
        if (!canBreakPermanently) {
            amount = Math.min(maxDamage - stack.func_77952_i(), amount);
        }
        boolean wouldBreak = stack.func_96631_a(amount, SilentGear.random, player);
        if (GearHelper.getDamageFactor(stack, maxDamage) != preDamageFactor) {
            GearData.recalculateStats((EntityPlayer)player, stack);
            if (player != null) {
                GearHelper.onDamageFactorChange(player, preDamageFactor, GearHelper.getDamageFactor(stack, maxDamage));
            }
        }
        if (GearHelper.isBroken(stack)) {
            entityLiving.func_70669_a(stack);
            GearData.incrementBrokenCount(stack);
            GearData.recalculateStats((EntityPlayer)player, stack);
            if (player != null) {
                GearHelper.notifyPlayerOfBrokenGear(stack, player);
            }
        } else if (canBreakPermanently && wouldBreak) {
            entityLiving.func_70669_a(stack);
            stack.func_190918_g(1);
        }
    }

    private static void onDamageFactorChange(EntityPlayerMP player, int preDamageFactor, int newDamageFactor) {
        if (newDamageFactor > preDamageFactor) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.5f, 2.0f);
            LibTriggers.GENERIC_INT.trigger(player, new ResourceLocation("silentgear", "damage_factor_change"), 1);
        }
    }

    private static void notifyPlayerOfBrokenGear(ItemStack stack, EntityPlayerMP player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.silentgear.notifyOnBreak", new Object[]{stack.func_200301_q()}));
    }

    private static int getDamageFactor(ItemStack stack, int maxDamage) {
        if (maxDamage == 0) {
            return 1;
        }
        int step = Math.max(1, maxDamage / 10);
        return stack.func_77952_i() / step;
    }

    public static int calcDamageClamped(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return 0;
        }
        if (!GearHelper.canBreakPermanently(stack)) {
            damage = damage > stack.func_77952_i() ? Math.min(stack.func_77958_k(), damage) : Math.max(0, damage);
        }
        return damage;
    }

    private static boolean canBreakPermanently(ItemStack stack) {
        return (Boolean)Config.GENERAL.gearBreaksPermanently.get() != false || GearData.hasPart(stack, MiscUpgrades.RED_CARD.getPart());
    }

    public static boolean isBroken(ItemStack stack) {
        if (GearHelper.canBreakPermanently(stack)) {
            return false;
        }
        int maxDamage = stack.func_77958_k();
        if (stack.func_190926_b() || maxDamage <= 0) {
            return false;
        }
        return stack.func_77952_i() >= maxDamage;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return (float)stack.func_77958_k() >= CommonItemStats.DURABILITY.getMaximumValue();
    }

    public static Item.Properties getBuilder(@Nullable ToolType toolType) {
        Item.Properties b = new Item.Properties().func_200917_a(1).func_200916_a(SilentGear.ITEM_GROUP);
        if (toolType != null) {
            b.addToolType(toolType, 3);
        }
        return b;
    }

    public static void addModelTypeProperty(ICoreItem item) {
        item.func_199767_j().func_185043_a(SilentGear.getId("model_type"), (stack, world, entity) -> (GearData.hasPartOftype(stack, PartType.ROD) ? 1 : 0) + (GearData.hasPartOftype(stack, PartType.MAIN) ? 2 : 0) + (GearData.hasPartOftype(stack, PartType.TIP) ? 4 : 0) + (item.requiresPartOfType(PartType.BOWSTRING) && GearData.hasPartOftype(stack, PartType.BOWSTRING) ? 8 : 0));
    }

    @Nullable
    public static GearType getType(ItemStack gear) {
        if (!(gear.func_77973_b() instanceof ICoreItem)) {
            return null;
        }
        return ((ICoreItem)gear.func_77973_b()).getGearType();
    }

    public static int getHarvestLevel(ItemStack stack, ToolType toolClass, @Nullable IBlockState state, @Nullable Set<Material> effectiveMaterials) {
        boolean effectiveOnMaterial;
        if (GearHelper.isBroken(stack) || !stack.func_77973_b().getToolTypes(stack).contains(toolClass)) {
            return -1;
        }
        int level = GearData.getStatInt(stack, CommonItemStats.HARVEST_LEVEL);
        if (state == null) {
            return level;
        }
        boolean bl = effectiveOnMaterial = effectiveMaterials == null || effectiveMaterials.contains(state.func_185904_a());
        if (effectiveOnMaterial && state.func_177230_c().getHarvestLevel(state) <= level) {
            return level;
        }
        return -1;
    }

    public static void setHarvestLevel(ICoreItem item, String toolClass, int level, Set<String> mutableSet) {
        boolean add = level >= 0;
        SilentGear.LOGGER.info("{}: {} tool class \"{}\"", (Object)item.getClass().getSimpleName(), (Object)(add ? "set" : "remove"), (Object)toolClass);
        if (add) {
            mutableSet.add(toolClass);
        } else {
            mutableSet.remove(toolClass);
        }
    }

    public static float getDestroySpeed(ItemStack stack, IBlockState state, @Nullable Set<Material> extraMaterials) {
        if (GearHelper.isBroken(stack)) {
            return 0.25f;
        }
        float speed = GearData.getStat(stack, CommonItemStats.HARVEST_SPEED);
        if (stack.func_77973_b().canHarvestBlock(stack, state)) {
            return speed;
        }
        for (ToolType type : stack.func_77973_b().getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return speed;
        }
        if (extraMaterials != null && extraMaterials.contains(state.func_185904_a())) {
            return speed;
        }
        return 1.0f;
    }

    public static boolean onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!GearHelper.isBroken(stack) && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnBlockBreak(stack, world, state, pos);
            GearHelper.attemptDamage(stack, damage, entityLiving);
        }
        GearHelper.selfHarmWithToolHead(stack, entityLiving);
        return true;
    }

    public static boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean isBroken = GearHelper.isBroken(stack);
        if (!isBroken && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnHitEntity(stack, target, attacker);
            GearHelper.attemptDamage(stack, damage, attacker);
        }
        GearHelper.selfHarmWithToolHead(stack, attacker);
        return !isBroken;
    }

    private static void selfHarmWithToolHead(final ItemStack stack, EntityLivingBase user) {
        ICoreItem item;
        if (stack.func_77973_b() instanceof ICoreItem && (item = (ICoreItem)stack.func_77973_b()).requiresPartOfType(PartType.ROD) && !GearData.hasPartOftype(stack, PartType.ROD)) {
            float damageAmount = item.getStat(stack, CommonItemStats.MELEE_DAMAGE) / 2.0f;
            DamageSource source = new DamageSource("silentgear.broken_tool"){

                @Nonnull
                public ITextComponent func_151519_b(EntityLivingBase entity) {
                    return new TextComponentTranslation("death.silentgear.broken_tool", new Object[]{entity.func_145748_c_(), stack.func_200301_q()});
                }
            }.func_76348_h();
            user.func_70097_a(source, damageAmount);
            if (user instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)user;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("misc.silentgear.missingRod.attack", new Object[0]), true);
            }
        }
    }

    public static void inventoryTick(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (world.func_82737_E() % 20L == 0L && !GearData.isRandomGradingDone(stack)) {
            MaterialGrade median = SilentGear.random.nextInt(100) < 20 ? MaterialGrade.D : (SilentGear.random.nextInt(100) < 40 ? MaterialGrade.B : MaterialGrade.C);
            PartDataList parts = PartDataList.of(new PartData[0]);
            for (PartData data : GearData.getConstructionParts(stack)) {
                if (data.getGrade() == MaterialGrade.NONE) {
                    MaterialGrade grade = MaterialGrade.selectRandom(SilentGear.random, median, 1.5, MaterialGrade.S);
                    parts.add(PartData.of(data.getPart(), grade, data.getCraftingItem()));
                    continue;
                }
                parts.add(data);
            }
            GearData.writeConstructionParts(stack, parts);
            GearData.setRandomGradingDone(stack, true);
            GearData.recalculateStats(player, stack);
        }
        if (!world.field_72995_K) {
            TraitHelper.tickTraits(world, player, stack, isSelected);
        }
    }

    public static boolean shouldUseFallbackColor(ItemStack stack, PartData part) {
        return false;
    }

    public static EnumRarity getRarity(ItemStack stack) {
        int rarity = GearData.getStatInt(stack, CommonItemStats.RARITY);
        if (stack.func_77948_v()) {
            rarity += 20;
        }
        if (rarity < 40) {
            return EnumRarity.COMMON;
        }
        if (rarity < 80) {
            return EnumRarity.UNCOMMON;
        }
        if (rarity < 120) {
            return EnumRarity.RARE;
        }
        return EnumRarity.EPIC;
    }

    public static void fillItemGroup(ICoreItem item, ItemGroup group, Collection<ItemStack> items) {
        boolean inTab = false;
        for (ItemGroup tabInList : item.func_199767_j().getCreativeTabs()) {
            if (tabInList != group) continue;
            inTab = true;
            break;
        }
        if (!inTab) {
            return;
        }
        if (!subItemCache.containsKey(item.getGearType())) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 1; i <= 3; ++i) {
                ItemStack stack = GearHelper.createSampleItem(item, i);
                if (stack.func_190926_b()) continue;
                list.add(stack);
            }
            subItemCache.put(item.getGearType(), list);
        }
        items.addAll((Collection<ItemStack>)subItemCache.get(item.getGearType()));
    }

    private static ItemStack createSampleItem(ICoreItem item, int tier) {
        ItemStack result = GearGenerator.create(item, tier);
        GearData.setExampleTag(result, true);
        return result;
    }

    public static void resetSubItemsCache() {
        subItemCache.clear();
    }

    public static ITextComponent getDisplayName(ItemStack gear) {
        PartData part = GearData.getPrimaryPart(gear);
        if (part == null) {
            return new TextComponentTranslation(gear.func_77977_a(), new Object[0]);
        }
        ITextComponent partName = part.getDisplayName(gear);
        TextComponentTranslation gearName = new TextComponentTranslation(gear.func_77977_a() + ".nameProper", new Object[]{partName});
        if (gear.func_77973_b() instanceof ICoreTool) {
            ICoreItem item = (ICoreItem)gear.func_77973_b();
            if (item.requiresPartOfType(PartType.ROD) && GearData.getPartOfType(gear, PartType.ROD) == null) {
                return new TextComponentTranslation(gear.func_77977_a() + ".noRod", new Object[]{gearName});
            }
            if (item.requiresPartOfType(PartType.BOWSTRING) && GearData.getPartOfType(gear, PartType.BOWSTRING) == null) {
                return new TextComponentTranslation(gear.func_77977_a() + ".unstrung", new Object[]{gearName});
            }
        }
        return gearName;
    }
}

