/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.lib.util.generator.IRecipeBuilder;
import net.silentchaos512.lib.util.generator.RecipeGenerator;

public class GenRecipes {
    public static void generateAll() {
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("crimson_iron_smelting"), (IRecipeBuilder)RecipeGenerator.SmeltingBuilder.create((IItemProvider)CraftingItems.CRIMSON_IRON_INGOT).ingredient((Object)ModBlocks.CRIMSON_IRON_ORE).experience(1.0f));
        assert (CraftingItems.UPGRADE_BASE.getTag() != null);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("crafting_station"), (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)ModBlocks.CRAFTING_STATION).layout("#T#", "#U#", "#C#").key('#', (Object)ItemTags.field_199905_b).key('T', (Object)Blocks.field_150462_ai).key('U', CraftingItems.UPGRADE_BASE.getTag()).key('C', (Object)Tags.Items.CHESTS_WOODEN));
        assert (CraftingItems.ADVANCED_UPGRADE_BASE.getTag() != null);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("part_analyzer"), (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)ModBlocks.PART_ANALYZER).layout("QIQ", "I#I", "GGG").key('Q', (Object)Tags.Items.GEMS_QUARRTZ).key('I', (Object)Tags.Items.INGOTS_IRON).key('#', CraftingItems.ADVANCED_UPGRADE_BASE.getTag()).key('G', (Object)Tags.Items.INGOTS_GOLD));
        assert (CraftingItems.CRIMSON_IRON_INGOT.getTag() != null);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("salvager"), (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)ModBlocks.SALVAGER).layout(" P ", "/I/", "/#/").key('P', (Object)Blocks.field_150331_J).key('/', CraftingItems.CRIMSON_IRON_INGOT.getTag()).key('I', (Object)Tags.Blocks.STORAGE_BLOCKS_IRON).key('#', (Object)Blocks.field_150343_Z));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("netherwood_planks"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)ModBlocks.NETHERWOOD_PLANKS, (int)4).ingredient((Object)ModBlocks.NETHERWOOD_LOG));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("blue_dye_from_flower"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.BLUE_DYE, (int)2).ingredient((Object)ModBlocks.FLOWER));
        GenRecipes.blueprints(ModItems.sword, (RecipeGenerator.ShapedBuilder b) -> b.layout("#", "#", "/"));
        GenRecipes.blueprints(ModItems.dagger, (RecipeGenerator.ShapedBuilder b) -> b.layout("#", "/"));
        GenRecipes.blueprints(ModItems.katana, (RecipeGenerator.ShapedBuilder b) -> b.layout("##", "# ", "/ "));
        GenRecipes.blueprints(ModItems.machete, (RecipeGenerator.ShapedBuilder b) -> b.layout("  #", " ##", "/  "));
        GenRecipes.blueprints(ModItems.pickaxe, (RecipeGenerator.ShapedBuilder b) -> b.layout("###", " / ", " / "));
        GenRecipes.blueprints(ModItems.shovel, (RecipeGenerator.ShapedBuilder b) -> b.layout("#", "/", "/"));
        GenRecipes.blueprints(ModItems.axe, (RecipeGenerator.ShapedBuilder b) -> b.layout("##", "#/", " /"));
        GenRecipes.blueprints(ModItems.hammer, (RecipeGenerator.ShapedBuilder b) -> b.layout("###", "###", "#/#"));
        GenRecipes.blueprints(ModItems.excavator, (RecipeGenerator.ShapedBuilder b) -> b.layout("# #", "###", " / "));
        GenRecipes.blueprints(ModItems.mattock, (RecipeGenerator.ShapedBuilder b) -> b.layout("## ", "#/#", " / "));
        GenRecipes.blueprints(ModItems.sickle, (RecipeGenerator.ShapedBuilder b) -> b.layout(" #", "##", "/ "));
        GenRecipes.blueprints(ModItems.bow, (RecipeGenerator.ShapedBuilder b) -> b.layout(" #/", "# /", " #/"));
        GenRecipes.blueprints(ModItems.helmet, (RecipeGenerator.ShapedBuilder b) -> b.layout("###", "#/#"));
        GenRecipes.blueprints(ModItems.chestplate, (RecipeGenerator.ShapedBuilder b) -> b.layout("#/#", "###", "###"));
        GenRecipes.blueprints(ModItems.leggings, (RecipeGenerator.ShapedBuilder b) -> b.layout("###", "#/#", "# #"));
        GenRecipes.blueprints(ModItems.boots, (RecipeGenerator.ShapedBuilder b) -> b.layout("#/#", "# #"));
        GenRecipes.blueprints("rod", (RecipeGenerator.ShapedBuilder b) -> b.layout("#/", "#/"));
        assert (CraftingItems.BLUEPRINT_PAPER.getTag() != null);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("blueprint_book"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)ModItems.blueprintBook).ingredient((Object)Items.field_151122_aG).ingredient(CraftingItems.BLUEPRINT_PAPER.getTag(), 3));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("blueprint_paper"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.BLUEPRINT_PAPER, (int)4).ingredient((Object)"forge:paper", 4).ingredient((Object)Tags.Items.DYES_BLUE));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("upgrade_base_basic"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.UPGRADE_BASE, (int)4).ingredient((Object)"forge:paper", 2).ingredient((Object)ItemTags.field_199905_b).ingredient((Object)Tags.Items.STONE));
        assert (CraftingItems.DIAMOND_SHARD.getTag() != null);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("upgrade_base_advanced"), (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)CraftingItems.ADVANCED_UPGRADE_BASE).layout("///", "DUD", "GGG").key('/', CraftingItems.DIAMOND_SHARD.getTag()).key('D', (Object)Tags.Items.DYES_BLUE).key('U', CraftingItems.UPGRADE_BASE.getTag()).key('G', (Object)Tags.Items.NUGGETS_GOLD));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("crimson_steel_ingot"), (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)CraftingItems.CRIMSON_STEEL_INGOT).layout("/ /", "#C#", "# #").key('/', (Object)Tags.Items.RODS_BLAZE).key('#', CraftingItems.CRIMSON_IRON_INGOT.getTag()).key('C', (Object)Items.field_151064_bs));
        RecipeGenerator.compress9((ResourceLocation)GenRecipes.name("diamond_shards"), (IItemProvider)Items.field_151045_i, (IItemProvider)CraftingItems.DIAMOND_SHARD);
        RecipeGenerator.compress9((ResourceLocation)GenRecipes.name("emerald_shards"), (IItemProvider)Items.field_151166_bC, (IItemProvider)CraftingItems.EMERALD_SHARD);
        RecipeGenerator.compress9((ResourceLocation)GenRecipes.name("crimson_iron"), (IItemProvider)CraftingItems.CRIMSON_IRON_INGOT, (IItemProvider)CraftingItems.CRIMSON_IRON_NUGGET);
        RecipeGenerator.compress9((ResourceLocation)GenRecipes.name("crimson_steel"), (IItemProvider)CraftingItems.CRIMSON_STEEL_INGOT, (IItemProvider)CraftingItems.CRIMSON_STEEL_NUGGET);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("sinew_smelting"), (IRecipeBuilder)RecipeGenerator.SmeltingBuilder.create((IItemProvider)CraftingItems.DRIED_SINEW).ingredient((Object)CraftingItems.SINEW).experience(0.35f));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("sinew_fibers"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.SINEW_FIBER, (int)3).ingredient((Object)CraftingItems.DRIED_SINEW));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("flax_string"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.FLAX_STRING).ingredient((Object)CraftingItems.FLAX_FIBER, 2));
        GenRecipes.tipUpgrade(CraftingItems.IRON_TIPPED_UPGRADE, (Tag<Item>)Tags.Items.INGOTS_IRON, 1);
        GenRecipes.tipUpgrade(CraftingItems.GOLD_TIPPED_UPGRADE, (Tag<Item>)Tags.Items.INGOTS_GOLD, 1);
        GenRecipes.tipUpgrade(CraftingItems.DIAMOND_TIPPED_UPGRADE, (Tag<Item>)Tags.Items.GEMS_DIAMOND, 1);
        GenRecipes.tipUpgrade(CraftingItems.EMERALD_TIPPED_UPGRADE, (Tag<Item>)Tags.Items.GEMS_EMERALD, 1);
        GenRecipes.tipUpgrade(CraftingItems.REDSTONE_COATED_UPGRADE, (Tag<Item>)Tags.Items.DUSTS_REDSTONE, 4);
        GenRecipes.tipUpgrade(CraftingItems.GLOWSTONE_COATED_UPGRADE, (Tag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4);
        GenRecipes.tipUpgrade(CraftingItems.LAPIS_COATED_UPGRADE, (Tag<Item>)Tags.Items.GEMS_LAPIS, 4);
        GenRecipes.tipUpgrade(CraftingItems.QUARTZ_TIPPED_UPGRADE, (Tag<Item>)Tags.Items.GEMS_QUARRTZ, 4);
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("spoon_upgrade"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.SPOON_UPGRADE).ingredient(CraftingItems.ADVANCED_UPGRADE_BASE.getTag()).ingredient((Object)Items.field_151047_v));
        RecipeGenerator.create((ResourceLocation)GenRecipes.name("red_card_upgrade"), (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)CraftingItems.RED_CARD_UPGRADE, (int)4).ingredient(CraftingItems.UPGRADE_BASE.getTag()).ingredient((Object)Tags.Items.DYES_RED));
        GenRecipes.bowstrings(CraftingItems.FLAX_BOWSTRING, CraftingItems.FLAX_STRING.getTag());
        GenRecipes.bowstrings(CraftingItems.PLAIN_BOWSTRING, "forge:string/string");
        GenRecipes.bowstrings(CraftingItems.SINEW_BOWSTRING, CraftingItems.SINEW_FIBER.getTag());
        GenRecipes.rods(CraftingItems.ROUGH_ROD, Tags.Items.RODS_WOODEN, 2, true);
        GenRecipes.rods(CraftingItems.STONE_ROD, Tags.Blocks.COBBLESTONE, 4, false);
        GenRecipes.rods(CraftingItems.IRON_ROD, Tags.Items.INGOTS_IRON, 4, false);
        GenRecipes.rods(CraftingItems.NETHERWOOD_STICK, (Object)ModBlocks.NETHERWOOD_PLANKS, 4, true);
    }

    private static void blueprints(ICoreItem item, Consumer<RecipeGenerator.ShapedBuilder> layout) {
        GenRecipes.blueprints(item.getGearType().getName(), layout);
    }

    private static void blueprints(String type, Consumer<RecipeGenerator.ShapedBuilder> layout) {
        RecipeGenerator.ShapedBuilder builder;
        ResourceLocation nameBlueprint = GenRecipes.name("blueprints/blueprint_" + type);
        ResourceLocation nameTemplate = GenRecipes.name("blueprints/template_" + type);
        Item blueprint = (Item)ForgeRegistries.ITEMS.getValue(nameBlueprint);
        Item template = (Item)ForgeRegistries.ITEMS.getValue(nameTemplate);
        if (blueprint != null) {
            builder = RecipeGenerator.ShapedBuilder.create((IItemProvider)blueprint);
            layout.accept(builder);
            assert (CraftingItems.BLUEPRINT_PAPER.getTag() != null);
            RecipeGenerator.create((ResourceLocation)nameBlueprint, (IRecipeBuilder)builder.group("silentgear:blueprints_" + type).key('#', CraftingItems.BLUEPRINT_PAPER.getTag()).key('/', (Object)Tags.Items.RODS_WOODEN));
        }
        if (template != null) {
            builder = RecipeGenerator.ShapedBuilder.create((IItemProvider)template);
            layout.accept(builder);
            RecipeGenerator.create((ResourceLocation)nameTemplate, (IRecipeBuilder)builder.group("silentgear:blueprints_" + type).key('#', (Object)ItemTags.field_202899_i).key('/', (Object)Tags.Items.RODS_WOODEN));
        }
    }

    private static void bowstrings(IItemProvider output, Object material) {
        ResourceLocation name = Objects.requireNonNull(output.func_199767_j().getRegistryName());
        RecipeGenerator.create((ResourceLocation)name, (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)output).group("silentgear:bowstrings").layout("/", "/", "/").key('/', material));
        ResourceLocation name2 = new ResourceLocation("silentgear", name.func_110623_a() + "2");
        RecipeGenerator.create((ResourceLocation)name2, (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)output).group("silentgear:bowstrings").ingredient((Object)"silentgear:blueprints/bowstring").ingredient(material, 3));
    }

    private static void rods(IItemProvider output, Object material, int count, boolean tilted) {
        ResourceLocation name = Objects.requireNonNull(output.func_199767_j().getRegistryName());
        RecipeGenerator.create((ResourceLocation)name, (IRecipeBuilder)RecipeGenerator.ShapedBuilder.create((IItemProvider)output, (int)count).layout(tilted ? " /" : "/", tilted ? "/ " : "/").key('/', material));
        ResourceLocation name2 = new ResourceLocation("silentgear", name.func_110623_a() + "2");
        RecipeGenerator.create((ResourceLocation)name2, (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)output, (int)count).ingredient((Object)"silentgear:blueprints/rod").ingredient(material, 2));
    }

    private static void tipUpgrade(IItemProvider output, Tag<Item> material, int materialCount) {
        ResourceLocation name = Objects.requireNonNull(output.func_199767_j().getRegistryName());
        assert (CraftingItems.UPGRADE_BASE.getTag() != null);
        RecipeGenerator.create((ResourceLocation)name, (IRecipeBuilder)RecipeGenerator.ShapelessBuilder.create((IItemProvider)output).group("silentgear:tip_upgrades").ingredient(CraftingItems.UPGRADE_BASE.getTag()).ingredient(material, materialCount));
    }

    private static ResourceLocation name(String name) {
        return new ResourceLocation("silentgear", name);
    }
}

