/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;

public interface IAOETool {
    @Nonnull
    public ToolType getAOEToolClass();

    @Nullable
    public RayTraceResult rayTraceBlocks(World var1, EntityPlayer var2);

    default public List<BlockPos> getExtraBlocks(World world, @Nullable RayTraceResult rt, EntityPlayer player, ItemStack stack) {
        IBlockState state;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (player.func_70093_af() || rt == null || rt.func_178782_a() == null || rt.field_178784_b == null) {
            return positions;
        }
        BlockPos pos = rt.func_178782_a();
        if (this.isEffectiveOnBlock(stack, world, pos, state = world.func_180495_p(pos))) {
            switch (rt.field_178784_b.func_176740_k()) {
                case Y: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.NORTH), stack, positions);
                    break;
                }
                case X: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.NORTH), stack, positions);
                    break;
                }
                case Z: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.DOWN), stack, positions);
                }
            }
        }
        return positions;
    }

    default public boolean isEffectiveOnBlock(ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return stack.func_77973_b().canHarvestBlock(stack, state) || ForgeHooks.canToolHarvestBlock((IWorldReader)world, (BlockPos)pos, (ItemStack)stack);
    }

    default public void attemptAddExtraBlock(World world, IBlockState state1, BlockPos pos2, ItemStack stack, List<BlockPos> list) {
        IBlockState state2 = world.func_180495_p(pos2);
        if (state2.func_185887_b((IBlockReader)world, pos2) < 0.0f) {
            return;
        }
        if (!world.func_175623_d(pos2) && BreakHandler.areBlocksSimilar(state1, state2) && (state2.func_177230_c().isToolEffective(state2, this.getAOEToolClass()) || stack.func_77973_b().canHarvestBlock(stack, state2))) {
            list.add(pos2);
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
    public static final class HighlightHandler {
        private HighlightHandler() {
        }

        @SubscribeEvent
        public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
            ItemStack stack;
            EntityPlayer player = event.getPlayer();
            if (player != null && event.getSubID() == 0 && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && (stack = player.func_184614_ca()).func_77973_b() instanceof IAOETool) {
                World world = player.func_130014_f_();
                IAOETool item = (IAOETool)stack.func_77973_b();
                for (BlockPos pos : item.getExtraBlocks(world, event.getTarget(), player, stack)) {
                    event.getContext().func_72731_b(player, new RayTraceResult(Vec3d.field_186680_a, EnumFacing.UP, pos), 0, event.getPartialTicks());
                }
            }
        }
    }

    public static final class BreakHandler {
        private static final Set<Block> ORE_BLOCKS = new HashSet<Block>();

        private BreakHandler() {
        }

        public static boolean onBlockStartBreak(ItemStack tool, BlockPos pos, EntityPlayer player) {
            World world = player.func_130014_f_();
            if (world.field_72995_K || !(player instanceof EntityPlayerMP) || !(tool.func_77973_b() instanceof IAOETool)) {
                return false;
            }
            IAOETool item = (IAOETool)tool.func_77973_b();
            RayTraceResult rt = item.rayTraceBlocks(world, player);
            IBlockState stateOriginal = world.func_180495_p(pos);
            if (rt != null && rt.field_72313_a == RayTraceResult.Type.BLOCK && item.isEffectiveOnBlock(tool, world, pos, stateOriginal)) {
                EnumFacing side = rt.field_178784_b;
                List<BlockPos> extraBlocks = item.getExtraBlocks(world, rt, player, tool);
                for (BlockPos pos2 : extraBlocks) {
                    IBlockState state = world.func_180495_p(pos2);
                    if (!world.func_175667_e(pos2) || !player.func_175151_a(pos2, side, tool) || !state.canHarvestBlock((IBlockReader)world, pos2, player)) continue;
                    if (player.field_71075_bZ.field_75098_d) {
                        state.func_177230_c().func_176208_a(world, pos2, state, player);
                        if (state.func_177230_c().removedByPlayer(state, world, pos2, player, false, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                        }
                    } else {
                        int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos2);
                        state.func_177230_c().func_176208_a(world, pos2, state, player);
                        tool.func_77973_b().func_179218_a(tool, world, state, pos2, (EntityLivingBase)player);
                        if (state.func_177230_c().removedByPlayer(state, world, pos2, player, true, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                            state.func_177230_c().func_180657_a(world, player, pos2, state, world.func_175625_s(pos2), tool);
                            state.func_177230_c().func_180637_b(world, pos2, xp);
                        }
                    }
                    world.func_175718_b(2001, pos, Block.func_196246_j((IBlockState)state));
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange((IBlockReader)world, pos));
                }
            }
            return false;
        }

        public static void buildOreBlocksSet() {
            ORE_BLOCKS.clear();
            for (Block block : ForgeRegistries.BLOCKS) {
                if (!(block instanceof BlockOre) && !Tags.Blocks.ORES.func_199685_a_((Object)block)) continue;
                ORE_BLOCKS.add(block);
            }
            SilentGear.LOGGER.info("IAOETool: Rebuilt ore block set, contains {} items", (Object)ORE_BLOCKS.size());
        }

        static boolean areBlocksSimilar(IBlockState state1, IBlockState state2) {
            int level2;
            MatchMode mode;
            Block block1 = state1.func_177230_c();
            Block block2 = state2.func_177230_c();
            boolean isOre1 = ORE_BLOCKS.contains(block1);
            boolean isOre2 = ORE_BLOCKS.contains(block2);
            MatchMode matchMode = mode = isOre1 && isOre2 ? (MatchMode)Config.GENERAL.matchModeOres.get() : (MatchMode)Config.GENERAL.matchModeStandard.get();
            if (mode == MatchMode.LOOSE || block1 == block2) {
                return true;
            }
            if (mode == MatchMode.STRICT || !isOre1 && isOre2) {
                return false;
            }
            int level1 = block1.getHarvestLevel(state1);
            return level1 >= (level2 = block2.getHarvestLevel(state2)) || level2 == 0;
        }
    }

    public static enum MatchMode {
        LOOSE,
        MODERATE,
        STRICT;

    }
}

