/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static float activateTraits(ItemStack gear, float inputValue, TraitFunction action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        float value = inputValue;
        for (INBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof NBTTagCompound) || (trait = TraitManager.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            value = action.apply(trait, level, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, ITrait trait) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called getTraitLevel on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return 0;
        }
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (INBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            ITrait traitOnGear;
            if (!(nbt instanceof NBTTagCompound) || (traitOnGear = TraitManager.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) != trait) continue;
            return tagCompound.func_74771_c("Level");
        }
        return 0;
    }

    public static int getTraitLevel(ItemStack gear, ResourceLocation traitId) {
        ITrait trait = TraitManager.get(traitId);
        return trait != null ? TraitHelper.getTraitLevel(gear, trait) : 0;
    }

    public static Map<ITrait, Integer> getTraits(ItemStack gear, Collection<PartData> parts) {
        ITrait[] keys;
        if (parts.isEmpty()) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        HashMap countPartsWithTrait = new HashMap();
        for (PartData part : parts) {
            part.getTraits(gear).forEach((trait, level) -> {
                result.merge((ITrait)trait, (Integer)level, (i1, i2) -> i1 + i2);
                countPartsWithTrait.merge(trait, 1, (i1, i2) -> i1 + i2);
            });
        }
        for (ITrait trait2 : keys = result.keySet().toArray(new ITrait[0])) {
            int partsWithTrait = (Integer)countPartsWithTrait.get(trait2);
            float divisor = Math.max(1, partsWithTrait);
            int value = Math.round((float)((Integer)result.get(trait2)).intValue() / divisor);
            result.put(trait2, MathHelper.func_76125_a((int)value, (int)1, (int)trait2.getMaxLevel()));
        }
        TraitHelper.cancelTraits(result, keys);
        return result;
    }

    private static void cancelTraits(Map<ITrait, Integer> mapToModify, ITrait[] keys) {
        block0: for (int i = 0; i < keys.length; ++i) {
            ITrait t1 = keys[i];
            if (!mapToModify.containsKey(t1)) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                int otherLevel;
                ITrait t2 = keys[j];
                if (!mapToModify.containsKey(t2) || !t1.willCancelWith(t2)) continue;
                int level = mapToModify.get(t1);
                int cancelLevel = t1.getCanceledLevel(level, t2, otherLevel = mapToModify.get(t2).intValue());
                if (cancelLevel > 0) {
                    mapToModify.put(t1, cancelLevel);
                    mapToModify.remove(t2);
                    continue;
                }
                if (cancelLevel < 0) {
                    mapToModify.put(t2, -cancelLevel);
                    mapToModify.remove(t1);
                    continue block0;
                }
                mapToModify.remove(t1);
                mapToModify.remove(t2);
                continue block0;
            }
        }
    }

    static void tickTraits(World world, @Nullable EntityPlayer player, ItemStack gear, boolean isEquipped) {
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (INBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof NBTTagCompound) || (trait = TraitManager.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            trait.onUpdate(new TraitActionContext(player, level, gear), isEquipped);
        }
    }
}

