/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.AbstractFlowersFeature;
import net.minecraft.world.gen.feature.CompositeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MinableConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.BasePlacement;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.world.feature.NetherwoodTreeFeature;
import net.silentchaos512.lib.world.feature.PlantFeature;
import net.silentchaos512.utils.MathUtils;

public final class ModWorldFeatures {
    private ModWorldFeatures() {
    }

    public static void addFeaturesToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (MathUtils.inRangeInclusive((double)biome.func_185353_n(), (double)0.5, (double)1.5)) {
                ModWorldFeatures.addFlowers(biome);
            }
            if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS || biome.func_201856_r() == Biome.Category.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        }
    }

    private static void addFlowers(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, (CompositeFeature)Biome.func_201861_a((AbstractFlowersFeature)new PlantFeature(ModBlocks.FLOWER.asBlockState(), 32, 10), (BasePlacement)Biome.field_201912_g, (IPlacementConfig)new FrequencyConfig(1)));
    }

    private static void addWildFlax(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, (CompositeFeature)Biome.func_201861_a((AbstractFlowersFeature)new PlantFeature(((FlaxPlant)ModBlocks.FLAX_PLANT.asBlock()).getMaturePlant(), 32, 4), (BasePlacement)Biome.field_201912_g, (IPlacementConfig)new FrequencyConfig(1)));
    }

    private static void addNetherwoodTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_201864_a((Feature)new NetherwoodTreeFeature(true), (IFeatureConfig)IFeatureConfig.field_202429_e, (BasePlacement)Biome.field_201922_q, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.15f, 6)));
    }

    private static void addCrimsonIronOre(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_201864_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new MinableConfig(state -> state.func_177230_c() == Blocks.field_150424_aL, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 6), (BasePlacement)Biome.field_201923_r, (IPlacementConfig)new CountRangeConfig(24, 24, 0, 120)));
    }
}

