/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world.feature;

import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.lib.util.MathUtils;

public class NetherwoodTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState TRUNK = ModBlocks.NETHERWOOD_LOG.asBlockState();
    private static final IBlockState LEAF = ModBlocks.NETHERWOOD_LEAVES.asBlockState();

    public NetherwoodTreeFeature(boolean notify) {
        super(notify);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int startY = Math.min(position.func_177956_o(), 96);
        position = new BlockPos(position.func_177958_n(), startY, position.func_177952_p());
        IBlockState state = worldIn.func_180495_p(position);
        while (state.func_177230_c().canBeReplacedByLeaves(state, (IWorldReaderBase)worldIn, position) && startY > 0) {
            position = position.func_177977_b();
            state = worldIn.func_180495_p(position);
        }
        state = worldIn.func_180495_p(position);
        if (((NetherwoodSapling)ModBlocks.NETHERWOOD_SAPLING.asBlock()).canBlockStay(worldIn, position, state)) {
            this.func_202278_a(worldIn, position, TRUNK);
            int height = MathUtils.nextIntInclusive((int)4, (int)7);
            int endY = startY + height;
            for (int y = startY; y < endY + 2; ++y) {
                BlockPos pos = position.func_177981_b(y - startY);
                if (y < endY) {
                    this.func_202278_a(worldIn, pos, TRUNK);
                } else {
                    this.tryPlaceLeaves(worldIn, pos, null);
                }
                if (y == startY || y >= endY + 1) continue;
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    this.tryPlaceLeaves(worldIn, pos, facing);
                }
            }
        }
        return true;
    }

    private void tryPlaceLeaves(IWorld worldIn, BlockPos position, @Nullable EnumFacing side) {
        BlockPos pos = side != null ? position.func_177972_a(side) : position;
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().canBeReplacedByLeaves(state, (IWorldReaderBase)worldIn, pos)) {
            this.func_202278_a(worldIn, pos, LEAF);
        }
    }
}

