/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.gear.IProxy;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.DebugOverlay;
import net.silentchaos512.gear.client.event.ExtraBlockBreakHandler;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.models.ArmorItemModel;
import net.silentchaos512.gear.client.models.ToolModel;
import net.silentchaos512.gear.compat.mineandslash.MineAndSlashCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModCommands;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModEntities;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.init.NerfedGear;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.IAOETool;
import net.silentchaos512.gear.world.ModWorldFeatures;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.util.LibHooks;

class SideProxy
implements IProxy {
    @Nullable
    private static MinecraftServer server;

    SideProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::imcProcess);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModBlocks::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModContainers::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModItems::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModTileEntities::registerAll);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStopping);
        Config.init();
        Network.init();
        ModLootStuff.init();
        ModRecipes.init();
        ArgumentTypes.func_218136_a((String)"material_grade", MaterialGrade.Argument.class, (IArgumentSerializer)new ArgumentSerializer(MaterialGrade.Argument::new));
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(ModWorldFeatures::addFeaturesToBiomes);
        IAOETool.BreakHandler.buildOreBlocksSet();
        InitialSpawnItems.add((ResourceLocation)SilentGear.getId("starter_blueprints"), p -> {
            if (((Boolean)Config.GENERAL.spawnWithStarterBlueprints.get()).booleanValue()) {
                return Collections.singleton(ModItems.blueprintPackage.getStack());
            }
            return Collections.emptyList();
        });
        LibHooks.registerCompostable((float)0.3f, (IItemProvider)ModItems.flaxseeds);
        LibHooks.registerCompostable((float)0.5f, (IItemProvider)CraftingItems.FLAX_FIBER);
        NerfedGear.init();
        if (ModList.get().isLoaded("mmorpg") && ((Boolean)Config.GENERAL.mineAndSlashSupport.get()).booleanValue()) {
            MineAndSlashCompat.init();
        }
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void serverAboutToStart(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        resourceManager.func_219534_a((IFutureReloadListener)TraitManager.INSTANCE);
        resourceManager.func_219534_a((IFutureReloadListener)PartManager.INSTANCE);
    }

    private static void serverStarting(FMLServerStartingEvent event) {
        ModCommands.registerAll((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    private static void serverStarted(FMLServerStartedEvent event) {
        server = event.getServer();
        SilentGear.LOGGER.info(TraitManager.MARKER, "Gear traits loaded: {}", (Object)TraitManager.getValues().size());
        SilentGear.LOGGER.info(PartManager.MARKER, "Gear parts loaded: {}", (Object)PartManager.getValues().size());
    }

    private static void serverStopping(FMLServerStoppingEvent event) {
        server = null;
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return null;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return server;
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ColorHandlers::onItemColors);
            MinecraftForge.EVENT_BUS.register((Object)ExtraBlockBreakHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)TooltipHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            if (SilentGear.isDevBuild()) {
                MinecraftForge.EVENT_BUS.register((Object)new DebugOverlay());
            }
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)ToolModel.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)ArmorItemModel.Loader.INSTANCE);
        }

        private static void clientSetup(FMLClientSetupEvent event) {
            ModEntities.registerRenderers(event);
            ModTileEntities.registerRenderers(event);
            ModContainers.registerScreens(event);
        }

        private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        }

        @Override
        @Nullable
        public PlayerEntity getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

