/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.type.BindingPart;
import net.silentchaos512.gear.parts.type.BowstringPart;
import net.silentchaos512.gear.parts.type.GripPart;
import net.silentchaos512.gear.parts.type.HighlightPart;
import net.silentchaos512.gear.parts.type.MainPart;
import net.silentchaos512.gear.parts.type.RodPart;
import net.silentchaos512.gear.parts.type.TipPart;
import net.silentchaos512.gear.parts.type.UpgradePart;

public final class PartType {
    private static final Map<ResourceLocation, PartType> VALUES = new HashMap<ResourceLocation, PartType>();
    public static final PartType BINDING = PartType.create(SilentGear.getId("binding"), "b", PartType.createSerializer("binding", BindingPart::new));
    public static final PartType BOWSTRING = PartType.create(SilentGear.getId("bowstring"), "B", PartType.createSerializer("bowstring", BowstringPart::new));
    public static final PartType GRIP = PartType.create(SilentGear.getId("grip"), "G", PartType.createSerializer("grip", GripPart::new));
    public static final PartType HIGHLIGHT = PartType.create(SilentGear.getId("highlight"), "h", PartType.createSerializer("highlight", HighlightPart::new));
    public static final PartType MAIN = PartType.create(SilentGear.getId("main"), "M", PartType.createSerializer("main", MainPart::new));
    public static final PartType MISC_UPGRADE = PartType.create(SilentGear.getId("misc_upgrade"), "U", PartType.createSerializer("misc_upgrade", UpgradePart::new));
    public static final PartType ROD = PartType.create(SilentGear.getId("rod"), "R", PartType.createSerializer("rod", RodPart::new));
    public static final PartType TIP = PartType.create(SilentGear.getId("tip"), "T", PartType.createSerializer("tip", TipPart::new));
    private final ResourceLocation name;
    private final String debugSymbol;
    private final int maxPerItem;
    private final IPartSerializer<? extends IGearPart> serializer;

    @Deprecated
    public static PartType create(String name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(new ResourceLocation(name), debugSymbol, serializer);
    }

    public static PartType create(ResourceLocation name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        if (VALUES.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", name));
        }
        int maxPerItem = name.equals((Object)SilentGear.getId("main")) ? 9 : 1;
        PartType type = new PartType(name, debugSymbol, maxPerItem, serializer);
        VALUES.put(name, type);
        return type;
    }

    @Deprecated
    @Nullable
    public static PartType get(String name) {
        return PartType.get(new ResourceLocation(name));
    }

    @Nullable
    public static PartType get(ResourceLocation name) {
        return VALUES.get(name);
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    private PartType(ResourceLocation name, String debugSymbol, int maxPerItem, IPartSerializer<? extends IGearPart> serializer) {
        this.name = name;
        this.debugSymbol = debugSymbol;
        this.maxPerItem = maxPerItem;
        this.serializer = serializer;
    }

    public ITextComponent getDisplayName(int tier) {
        return new TranslationTextComponent("part." + this.name.func_110624_b() + ".type." + this.name.func_110623_a(), new Object[]{tier});
    }

    public IPartSerializer<? extends IGearPart> getSerializer() {
        return this.serializer;
    }

    public String toString() {
        return "PartType[" + this.debugSymbol + "]{name='" + this.name + "'}";
    }

    private static <T extends AbstractGearPart> IPartSerializer<T> createSerializer(String id, Function<ResourceLocation, T> function) {
        return new AbstractGearPart.Serializer<T>(new ResourceLocation("silentgear", id), function);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getDebugSymbol() {
        return this.debugSymbol;
    }

    public int getMaxPerItem() {
        return this.maxPerItem;
    }
}

