/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.stats.StatInstance;

@ParametersAreNonnullByDefault
public class ItemStat {
    public static final Map<String, ItemStat> ALL_STATS = new LinkedHashMap<String, ItemStat>();
    protected final ResourceLocation name;
    protected final float defaultValue;
    protected final float minimumValue;
    protected final float maximumValue;
    Function<Float, Float> missingRodFunction;
    private boolean isHidden = false;
    private boolean synergyApplies = false;
    private boolean affectedByGrades = true;
    public final boolean displayAsInt;
    public final TextFormatting displayColor;
    private static final float WEIGHT_BASE_MIN = 2.0f;
    private static final float WEIGHT_BASE_MAX = 40.0f;
    private static final float WEIGHT_DEVIATION_COEFF = 2.0f;

    public ItemStat(ResourceLocation name, float defaultValue, float minValue, float maxValue, boolean displayAsInt, TextFormatting displayColor) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.displayAsInt = displayAsInt;
        this.displayColor = displayColor;
        if (this.minimumValue > this.maximumValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (this.defaultValue < this.minimumValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (this.defaultValue > this.maximumValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
        ALL_STATS.put(name.func_110623_a(), this);
    }

    public float clampValue(float value) {
        value = MathHelper.func_76131_a((float)value, (float)this.minimumValue, (float)this.maximumValue);
        return value;
    }

    public float compute(float baseValue, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, true, modifiers);
    }

    public float compute(float baseValue, boolean clampValue, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        float primaryMod = ItemStat.getPrimaryMod(modifiers);
        float f0 = baseValue;
        int count = 0;
        float totalWeight = 0.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.AVG) continue;
            float weight = ItemStat.getModifierWeight(mod, primaryMod, ++count);
            totalWeight += weight;
            f0 += mod.getValue() * weight;
        }
        if (count > 0) {
            f0 /= totalWeight;
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.ADD) continue;
            f0 += mod.getValue();
        }
        float f1 = f0;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL1) continue;
            f1 += f0 * mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL2) continue;
            f1 *= 1.0f + mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MAX) continue;
            f1 = Math.max(f1, mod.getValue());
        }
        return clampValue ? this.clampValue(f1) : f1;
    }

    private static float getPrimaryMod(Iterable<StatInstance> modifiers) {
        float primaryMod = -1.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.AVG || !(primaryMod < 0.0f)) continue;
            primaryMod = mod.getValue();
        }
        return primaryMod > 0.0f ? primaryMod : 1.0f;
    }

    private static float getModifierWeight(StatInstance mod, float primaryMod, int count) {
        float weightBase = 2.0f + 2.0f * (mod.getValue() - primaryMod) / primaryMod;
        float weightBaseClamped = MathHelper.func_76131_a((float)weightBase, (float)2.0f, (float)40.0f);
        return (float)Math.pow(weightBaseClamped, -(count == 0 ? (double)count : 0.5 + (double)(0.5f * (float)count)));
    }

    public StatInstance computeForDisplay(float baseValue, MaterialGrade grade, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return new StatInstance("no_mods", baseValue, StatInstance.Operation.AVG);
        }
        boolean add = true;
        for (StatInstance inst : modifiers) {
            StatInstance.Operation op = inst.getOp();
            if (op != StatInstance.Operation.AVG && op != StatInstance.Operation.ADD && op != StatInstance.Operation.MAX) continue;
            add = false;
            break;
        }
        float value = this.compute(baseValue + (float)add, false, modifiers) - (float)add;
        if (this.affectedByGrades) {
            float gradeBonus = 1.0f + (float)grade.bonusPercent / 100.0f;
            value *= gradeBonus;
        }
        StatInstance.Operation op = modifiers.iterator().next().getOp();
        return new StatInstance("display_" + this.name, value, op);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public ItemStat setHidden(boolean value) {
        this.isHidden = value;
        return this;
    }

    public boolean doesSynergyApply() {
        return this.synergyApplies;
    }

    public ItemStat setSynergyApplies(boolean value) {
        this.synergyApplies = value;
        return this;
    }

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    public ItemStat setAffectedByGrades(boolean value) {
        this.affectedByGrades = value;
        return this;
    }

    public float withMissingRodEffect(float statValue) {
        if (this.missingRodFunction == null) {
            return statValue;
        }
        return this.missingRodFunction.apply(Float.valueOf(statValue)).floatValue();
    }

    public ItemStat setMissingRodEffect(Function<Float, Float> function) {
        this.missingRodFunction = function;
        return this;
    }

    public String toString() {
        return String.format("ItemStat{%s, default=%.2f, min=%.2f, max=%.2f}", this.name, Float.valueOf(this.defaultValue), Float.valueOf(this.minimumValue), Float.valueOf(this.maximumValue));
    }

    @Deprecated
    public String translatedName() {
        return I18n.func_135052_a((String)("stat." + this.name.func_110624_b() + "." + this.name.func_110623_a()), (Object[])new Object[0]);
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("stat." + this.name.func_110624_b() + "." + this.name.func_110623_a(), new Object[0]);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getMinimumValue() {
        return this.minimumValue;
    }

    public float getMaximumValue() {
        return this.maximumValue;
    }
}

