/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import javax.annotation.Nonnegative;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.utils.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;

public class StatInstance {
    public static final StatInstance ZERO = new StatInstance("__zero__", 0.0f, Operation.ADD);
    private final String id;
    private final float value;
    private final Operation op;

    public StatInstance(String id, float value, Operation op) {
        this.id = id;
        this.value = value;
        this.op = op;
    }

    public static StatInstance makeBaseMod(float value) {
        return new StatInstance("_base_mod", value, Operation.ADD);
    }

    public static StatInstance makeGearMod(float multi) {
        return new StatInstance("_gear_mod", multi, Operation.MUL1);
    }

    public StatInstance copyAppendId(String append) {
        return this.copyWithNewId(this.id + append);
    }

    public StatInstance copyWithNewId(String newId) {
        return new StatInstance(newId, this.value, this.op);
    }

    public String formattedString(@Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s" + "%." + decimalPlaces + "f" + "%s";
        switch (this.op) {
            case ADD: {
                TextFormatting color = this.getFormattedColor(this.value, 0.0f, addColor);
                return color + String.format(format, this.value < 0.0f ? "" : "+", Float.valueOf(this.value), "");
            }
            case AVG: {
                return String.format(format, "", Float.valueOf(this.value), "");
            }
            case MAX: {
                return String.format(format, "^", Float.valueOf(this.value), "");
            }
            case MUL1: {
                int percent = Math.round(100.0f * this.value);
                TextFormatting color = this.getFormattedColor(percent, 0.0f, addColor);
                format = "%s%d%%";
                return color + String.format(format, percent < 0 ? "" : "+", percent);
            }
            case MUL2: {
                float val = 1.0f + this.value;
                TextFormatting color = this.getFormattedColor(val, 1.0f, addColor);
                return color + String.format(format, "x", Float.valueOf(val), "");
            }
        }
        throw new NotImplementedException("Unknown operation: " + (Object)((Object)this.op));
    }

    private TextFormatting getFormattedColor(float val, float whiteVal, boolean addColor) {
        if (!addColor) {
            return TextFormatting.WHITE;
        }
        return val < whiteVal ? TextFormatting.RED : (val == whiteVal ? TextFormatting.WHITE : TextFormatting.GREEN);
    }

    public boolean shouldList(IGearPart part, ItemStat stat, boolean advanced) {
        return advanced || this.value != 0.0f || part.getType() == PartType.MAIN && stat == ItemStats.HARVEST_LEVEL;
    }

    public String toString() {
        return String.format("StatInstance{%s, value=%f, op=%s}", new Object[]{this.id, Float.valueOf(this.value), this.op});
    }

    public static StatInstance read(String id, PacketBuffer buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)Operation.AVG);
        return new StatInstance(id, value, op);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeFloat(this.value);
        buffer.writeByte(this.op.ordinal());
    }

    public String getId() {
        return this.id;
    }

    public float getValue() {
        return this.value;
    }

    public Operation getOp() {
        return this.op;
    }

    public static enum Operation {
        AVG,
        ADD,
        MUL1,
        MUL2,
        MAX;


        public static Operation byName(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return AVG;
        }
    }
}

