/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.analyzer;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gear.block.analyzer.PartAnalyzerTileEntity;

public class PartAnalyzerBlock
extends ContainerBlock {
    private static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape VOXEL_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public PartAnalyzerBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 30.0f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.SOUTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PartAnalyzerTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PartAnalyzerTileEntity) {
            player.func_213829_a((INamedContainerProvider)tileEntity);
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        Direction side = placer != null ? placer.func_174811_aO().func_176734_d() : Direction.SOUTH;
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)side), 2);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPE;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return face == Direction.DOWN;
    }
}

