/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.block.craftingstation.CraftingStationContainer;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.gui.GuiItemParts;
import net.silentchaos512.gear.client.gui.TexturedButton;
import net.silentchaos512.gear.client.util.TooltipFlagTC;
import net.silentchaos512.lib.util.TextRenderUtils;

public class CraftingStationScreen
extends ContainerScreen<CraftingStationContainer> {
    private static final ResourceLocation TEXTURE = SilentGear.getId("textures/gui/crafting_station.png");
    private TexturedButton buttonShowAllParts;

    public CraftingStationScreen(CraftingStationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 256;
    }

    public void init() {
        super.init();
        this.buttonShowAllParts = new TexturedButton(TEXTURE, this.field_147003_i + 149, this.field_147009_r + 5, 236, 166, 20, 18, (List<String>)ImmutableList.of((Object)new TranslationTextComponent("gui.silentgear.crafting_station.parts_button.hover1", new Object[0]).func_150254_d(), (Object)new TranslationTextComponent("gui.silentgear.crafting_station.parts_button.hover2", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150254_d()), b -> {
            if (this.minecraft != null) {
                this.minecraft.func_147108_a((Screen)new GuiItemParts((ITextComponent)new TranslationTextComponent("gui.silentgear.parts", new Object[0])));
            }
        });
        this.addButton((Widget)this.buttonShowAllParts);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.buttonShowAllParts.isMouseOver(mouseX, mouseY)) {
            this.buttonShowAllParts.drawHover(mouseX, mouseY);
        }
    }

    private static ITooltipFlag getTooltipFlag(ItemStack stack) {
        boolean ctrl = stack.func_77973_b() instanceof ICoreItem || KeyTracker.isControlDown();
        boolean alt = KeyTracker.isAltDown();
        boolean shift = KeyTracker.isShiftDown();
        return new TooltipFlagTC(ctrl, alt, shift, false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.minecraft == null) {
            return;
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"gui.silentgear.crafting_station.crafting", (Object[])new Object[0]), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"gui.silentgear.crafting_station.storage", (Object[])new Object[0]), -55.0f, 19.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.renderVersionString();
        ItemStack craftResult = ((CraftingStationContainer)this.field_147002_h).craftResult.func_70301_a(0);
        this.drawSlimeFace(craftResult);
        if (!craftResult.func_190926_b()) {
            List tooltip = craftResult.func_82840_a((PlayerEntity)this.minecraft.field_71439_g, CraftingStationScreen.getTooltipFlag(craftResult)).stream().map(ITextComponent::func_150254_d).map(s -> s.length() > 30 ? s.substring(0, 30) + "..." : s).collect(Collectors.toList());
            int maxWidth = 0;
            for (String line : tooltip) {
                maxWidth = Math.max(maxWidth, this.font.func_78256_a(line));
            }
            float scale = 75.0f / (float)maxWidth;
            int xPos = (int)((float)(this.field_146999_f - 82) / scale);
            int yPos = (int)((float)(this.field_147000_g - 160) / scale);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
            int step = (int)(scale * 10.0f);
            for (String line : tooltip) {
                this.font.func_175063_a(line, (float)xPos, (float)yPos, 0xFFFFFF);
                yPos += Math.round((float)step / scale);
            }
            GlStateManager.popMatrix();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft == null) {
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int xPos = (this.width - this.field_146999_f) / 2;
        int yPos = (this.height - this.field_147000_g) / 2;
        this.blit(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        int rowCount = 6;
        int rowWidth = 62;
        int totalHeight = 116;
        int x = xPos - 61;
        int y = yPos + (this.field_147000_g - 116) / 2;
        for (int i = 0; i < 6; ++i) {
            int height;
            int n = height = i == 0 || i == 5 ? 22 : 18;
            int ty = 194 + (i == 0 ? 0 : (i == 5 ? 40 : 22));
            this.blit(x, y, 0, ty, 62, height);
            y += height;
        }
        this.blit(x, y - 116 - 12, 0, 177, 62, 15);
        x = xPos + 171;
        y = yPos + 4;
        CraftingStationScreen.fill((int)x, (int)y, (int)(x + 80), (int)(y + 158), (int)-822083584);
    }

    private void renderVersionString() {
        String versionNumString = "Version: " + SilentGear.getLongVersion() + (SilentGear.isDevBuild() ? " (dev)" : "");
        int versionNumStringWidth = this.font.func_78256_a(versionNumString);
        float versionNumScale = 0.65f;
        TextRenderUtils.renderScaled((FontRenderer)this.font, (String)versionNumString, (int)((int)((float)this.field_146999_f - (float)versionNumStringWidth * versionNumScale) - 1), (int)(this.field_147000_g + 1), (float)versionNumScale, (int)0xCCCCCC, (boolean)false);
    }

    private void drawSlimeFace(ItemStack craftResult) {
        ResourceLocation name;
        if (this.minecraft == null) {
            return;
        }
        TextureManager textureManager = this.minecraft.func_110434_K();
        textureManager.func_110577_a(TEXTURE);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureY = 245;
        int textureX = craftResult.func_190926_b() ? (((CraftingStationContainer)this.field_147002_h).craftMatrix.func_191420_l() ? 223 : 234) : ((name = craftResult.func_77973_b().getRegistryName()) == null || "tconstruct".equals(name.func_110624_b()) ? 245 : 212);
        this.blit(this.field_146999_f - 18, this.field_147000_g - 17, textureX, 245, 11, 11);
        textureManager.func_110577_a(GUI_ICONS_LOCATION);
    }
}

