/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.event.GearEvents;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final int SPLIT_WIDTH = 160;
    private static final float TEXT_SCALE = 0.7f;

    @Nonnull
    public List<String> getDebugText() {
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return list;
        }
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return list;
        }
        Item item = heldItem.func_77973_b();
        if (item instanceof CoreCrossbow) {
            float pull = item.func_185045_a(new ResourceLocation("pull")).call(heldItem, (World)mc.field_71441_e, (LivingEntity)player);
            float pulling = item.func_185045_a(new ResourceLocation("pulling")).call(heldItem, (World)mc.field_71441_e, (LivingEntity)player);
            float charged = item.func_185045_a(new ResourceLocation("charged")).call(heldItem, (World)mc.field_71441_e, (LivingEntity)player);
            float firework = item.func_185045_a(new ResourceLocation("firework")).call(heldItem, (World)mc.field_71441_e, (LivingEntity)player);
            list.add(String.format("pull=%.1f", Float.valueOf(pull)));
            list.add(String.format("pulling=%.1f", Float.valueOf(pulling)));
            list.add(String.format("charged=%.1f", Float.valueOf(charged)));
            list.add(String.format("firework=%.1f", Float.valueOf(firework)));
            list.add(String.format("chargeTime=%d", CoreCrossbow.getChargeTime(heldItem)));
            return list;
        }
        RayTraceResult rt = mc.field_71476_x;
        if (rt != null && rt.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brt = (BlockRayTraceResult)rt;
            Entity renderViewEntity = mc.func_175606_aa();
            if (renderViewEntity != null) {
                BlockPos pos = brt.func_216350_a();
                BlockState state = renderViewEntity.field_70170_p.func_180495_p(pos);
                if (item instanceof ICoreTool) {
                    ToolType toolClass = state.func_177230_c().getHarvestTool(state);
                    int blockLevel = state.func_177230_c().getHarvestLevel(state);
                    int toolLevel = item.getHarvestLevel(heldItem, toolClass, (PlayerEntity)player, state);
                    boolean canHarvest = toolLevel >= blockLevel;
                    TextFormatting format = canHarvest ? TextFormatting.GREEN : TextFormatting.RED;
                    String name = toolClass == null ? "null" : toolClass.getName();
                    list.add(format + String.format("%s=%d (%d)", name, blockLevel, toolLevel));
                    float destroySpeed = heldItem.func_150997_a(state);
                    if (canHarvest) {
                        ITrait lustrous = TraitManager.get(TraitConst.LUSTROUS);
                        int level = TraitHelper.getTraitLevel(heldItem, lustrous);
                        int light = GearEvents.getLightForLustrousTrait((IEnviromentBlockReader)player.field_70170_p, player.func_180425_c());
                        float newSpeed = destroySpeed + (float)GearEvents.getLustrousSpeedBonus(level, light);
                        list.add(String.format("speed = %.1f", Float.valueOf(newSpeed)));
                    } else {
                        list.add(String.format("speed = %.1f", Float.valueOf(destroySpeed)));
                    }
                }
            }
        }
        return list;
    }

    public float getTextScale() {
        return 0.7f;
    }

    public int getSplitWidth() {
        return 160;
    }

    public boolean isHidden() {
        return !SilentGear.isDevBuild();
    }
}

