/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.lib.event.ClientTicks;

public final class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final boolean TRAIT_DISPLAY_CYCLE = false;
    private static final Pattern REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
    private static final Pattern REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");

    private TooltipHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onTooltip(ItemTooltipEvent event) {
        IGearPart part;
        ItemStack stack = event.getItemStack();
        IGearPart iGearPart = part = !stack.func_190926_b() ? PartManager.from(stack) : null;
        if (part != null) {
            TooltipHandler.onPartTooltip(event, stack, PartData.of(part));
            return;
        }
        if (Config.GENERAL.isNerfedItem(stack.func_77973_b())) {
            List toolTip = event.getToolTip();
            toolTip.add(Math.min(1, toolTip.size()), new TranslationTextComponent("misc.silentgear.poorlyMade", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    private static void onPartTooltip(ItemTooltipEvent event, ItemStack stack, PartData partData) {
        List<GearType> blacklist;
        IGearPart part = partData.getPart();
        event.getToolTip().add(part.getType().getDisplayName(part.getTier()).func_211708_a(TextFormatting.GREEN));
        ITooltipFlag flags = event.getFlags();
        List traits = partData.getTraits().stream().filter(inst -> inst.getTrait().showInTooltip(flags)).collect(Collectors.toList());
        int numTraits = traits.size();
        int traitIndex = TooltipHandler.getTraitDisplayIndex(numTraits);
        int i = 0;
        for (PartTraitInstance inst2 : traits) {
            if (traitIndex < 0 || traitIndex == i) {
                inst2.getTrait().addInformation(inst2.getLevel(), event.getToolTip(), flags);
            }
            ++i;
        }
        MaterialGrade grade = MaterialGrade.fromStack(stack);
        if (KeyTracker.isControlDown()) {
            if (part.getType() == PartType.MAIN) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(new StringTextComponent(" (Silent Gear)").func_211708_a(TextFormatting.RESET).func_211708_a(TextFormatting.ITALIC)));
            TooltipHandler.getPartStatLines(event, stack, part);
        } else {
            if (grade != MaterialGrade.NONE && part.getType() == PartType.MAIN) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.ctrlForStats", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
        if (part instanceof AbstractGearPart && !(blacklist = ((AbstractGearPart)part).getBlacklistedGearTypes()).isEmpty()) {
            int index = ClientTicks.ticksInGame() / 20 % blacklist.size();
            GearType gearType = blacklist.get(index);
            ITextComponent typeName = gearType.getDisplayName().func_211708_a(TextFormatting.WHITE);
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.blacklist", new Object[]{typeName}).func_211708_a(TextFormatting.RED));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getGradeLine(ItemTooltipEvent event, MaterialGrade grade) {
        event.getToolTip().add(grade.getDisplayName().func_211708_a(TextFormatting.AQUA));
    }

    private static void getPartStatLines(ItemTooltipEvent event, ItemStack stack, IGearPart part) {
        PartData partData = PartData.of(part, MaterialGrade.fromStack(stack), stack);
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, partData.getGrade(), modifiers)).shouldList(part, stat, event.getFlags().func_194127_a())) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.displayColor;
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            ITextComponent nameStr = stat.getDisplayName().func_211708_a(nameColor);
            int decimalPlaces = stat.displayAsInt && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statStr = statColor + REGEX_TRIM_TO_INT.matcher(inst.formattedString(decimalPlaces, false)).replaceFirst("");
            if (statStr.contains(".")) {
                statStr = REGEX_REMOVE_TRAILING_ZEROS.matcher(statStr).replaceFirst("");
            }
            if (modifiers.size() > 1) {
                statStr = statStr + "*";
            }
            if (stat == ItemStats.ARMOR_DURABILITY) {
                statStr = statStr + "x";
            }
            event.getToolTip().add(new StringTextComponent("- ").func_150257_a((ITextComponent)new TranslationTextComponent("stat.silentgear.displayFormat", new Object[]{nameStr, statStr})));
        }
    }
}

