/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.models.AbstractToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class ArmorItemModel
implements IUnbakedModel {
    private static final IUnbakedModel MODEL = new ArmorItemModel();
    @Nullable
    private final ResourceLocation textureMain;

    public ArmorItemModel() {
        this.textureMain = null;
    }

    public ArmorItemModel(@Nullable ResourceLocation textureMain) {
        this.textureMain = textureMain;
    }

    public ArmorItemModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation main = null;
        if (textures.containsKey((Object)"main")) {
            main = new ResourceLocation((String)textures.get((Object)"main"));
        }
        return new ArmorItemModel(main);
    }

    public ArmorItemModel process(ImmutableMap<String, String> customData) {
        ResourceLocation main = null;
        if (customData.containsKey((Object)"main")) {
            main = new ResourceLocation((String)customData.get((Object)"main"));
        }
        return new ArmorItemModel(main);
    }

    public Collection<ResourceLocation> func_187965_e() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ICoreArmor item : ModItems.armorClasses.values()) {
            GearType type = item.getGearType();
            for (IGearPart part : PartManager.getMains()) {
                ResourceLocation textureBroken;
                PartData partData = PartData.of(part);
                ResourceLocation textureMain = partData.getTexture(ItemStack.field_190927_a, type, PartPositions.ARMOR, 0);
                if (textureMain != null) {
                    builder.add((Object)textureMain);
                }
                if ((textureBroken = partData.getBrokenTexture(ItemStack.field_190927_a, type, PartPositions.ARMOR)) == null) continue;
                builder.add((Object)textureBroken);
            }
        }
        return builder.build();
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)ItemCameraTransforms.field_178357_a);
        TRSRTransformation transform = TRSRTransformation.identity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder texBuilder = ImmutableList.builder();
        if (this.textureMain != null) {
            texBuilder.add((Object)this.textureMain);
        }
        ImmutableList textures = texBuilder.build();
        int layerCount = textures.size();
        IBakedModel model = new ItemLayerModel(textures).bake(bakery, spriteGetter, sprite, format);
        builder.addAll((Iterable)model.func_200117_a(null, null, SilentGear.random));
        return new Baked((IModel)this, this.createQuadsMap(model, layerCount), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), new HashMap<String, IBakedModel>());
    }

    private ImmutableList<ImmutableList<BakedQuad>> createQuadsMap(IBakedModel model, int layerCount) {
        ArrayList<ImmutableList.Builder> list = new ArrayList<ImmutableList.Builder>();
        for (int i = 0; i < layerCount; ++i) {
            list.add(ImmutableList.builder());
        }
        for (BakedQuad quad : model.func_200117_a(null, null, SilentGear.random)) {
            ((ImmutableList.Builder)list.get(quad.func_178211_c())).add((Object)quad);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableList.Builder b : list) {
            builder.add((Object)b.build());
        }
        return builder.build();
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static final class Baked
    extends AbstractToolModel {
        public static Baked instance;

        public Baked(IModel parent, ImmutableList<ImmutableList<BakedQuad>> immutableList, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, immutableList, format, transforms, cache);
            instance = this;
        }

        public ItemOverrideList func_188617_f() {
            return OverrideHandler.INSTANCE;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return null;
        }

        public boolean func_188618_c() {
            return true;
        }
    }

    private static final class OverrideHandler
    extends ItemOverrideList {
        static final OverrideHandler INSTANCE = new OverrideHandler();

        private OverrideHandler() {
        }

        @Nullable
        public IBakedModel func_209581_a(IBakedModel parentModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            if (!(stack.func_77973_b() instanceof ICoreArmor)) {
                return parentModel;
            }
            Baked model = (Baked)parentModel;
            ICoreArmor itemArmor = (ICoreArmor)stack.func_77973_b();
            String key = GearData.getCachedModelKey(stack, 0);
            stack.func_196082_o().func_74778_a("debug_modelkey", key);
            if (!GearClientHelper.modelCache.containsKey(key)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                this.processTexture(stack, itemArmor.getGearType(), PartPositions.ARMOR, itemArmor.getPrimaryPart(stack), GearHelper.isBroken(stack), (ImmutableMap.Builder<String, String>)builder);
                IModel parent = model.getParent().retexture(builder.build());
                Function<ResourceLocation, IUnbakedModel> modelGetter = location -> null;
                Function<ResourceLocation, TextureAtlasSprite> spriteGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                return null;
            }
            ColorHandlers.gearColorCache.put(key, new Integer[]{itemArmor.getPrimaryPart(stack).getColor(stack, 0)});
            return GearClientHelper.modelCache.get(key);
        }

        private void processTexture(ItemStack stack, GearType toolClass, IPartPosition position, PartData part, boolean isBroken, ImmutableMap.Builder<String, String> builder) {
            ResourceLocation texture;
            if (part != null && (texture = isBroken ? part.getBrokenTexture(stack, toolClass, position) : part.getTexture(stack, toolClass, position, 0)) != null) {
                builder.put((Object)position.getModelIndex(), (Object)texture.toString());
            }
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            boolean matchesPath = ModItems.armorClasses.keySet().stream().anyMatch(s -> modelLocation.func_110623_a().equals(s));
            return modelLocation.func_110624_b().equals("silentgear") && matchesPath;
        }

        public IUnbakedModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }
    }
}

