/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class GearPartSwapRecipe
implements ICraftingRecipe {
    public static final ResourceLocation NAME = new ResourceLocation("silentgear", "swap_gear_part");
    public static final Serializer SERIALIZER = new Serializer();

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return false;
        }
        ICoreItem item = (ICoreItem)gear.func_77973_b();
        Collection others = list.allMatches(stack -> !(stack.func_77973_b() instanceof ICoreItem));
        if (others.isEmpty()) {
            return false;
        }
        HashSet<PartType> typesFound = new HashSet<PartType>();
        for (ItemStack stack2 : others) {
            PartData part = PartData.fromStackFast(stack2);
            if (part == null) {
                return false;
            }
            PartType type = part.getType();
            if (type == PartType.MAIN || !item.requiresPartOfType(type) || typesFound.contains(type)) {
                return false;
            }
            typesFound.add(type);
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Collection others = list.allMatches(stack -> !(stack.func_77973_b() instanceof ICoreItem));
        if (others.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = gear.func_77946_l();
        PartDataList parts = GearData.getConstructionParts(result);
        for (ItemStack stack2 : others) {
            PartData part = PartData.from(stack2);
            if (part == null) {
                return ItemStack.field_190927_a;
            }
            PartType type = part.getType();
            parts.removeIf(p -> p.getType() == type);
            parts.add(part);
        }
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result, null);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GearPartSwapRecipe> {
        public GearPartSwapRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new GearPartSwapRecipe();
        }

        public GearPartSwapRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new GearPartSwapRecipe();
        }

        public void write(PacketBuffer buffer, GearPartSwapRecipe recipe) {
        }
    }
}

