/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.Collection;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class ReplaceToolHeadRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("replace_tool_head");
    public static final IRecipeSerializer<ReplaceToolHeadRecipe> SERIALIZER = new SpecialRecipeSerializer(ReplaceToolHeadRecipe::new);

    public ReplaceToolHeadRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack tool1 = ItemStack.field_190927_a;
        ItemStack tool2 = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICoreTool) {
                if (tool1.func_190926_b()) {
                    tool1 = stack;
                    continue;
                }
                if (tool2.func_190926_b()) {
                    tool2 = stack;
                    continue;
                }
                return false;
            }
            return false;
        }
        return !tool1.func_190926_b() && !tool2.func_190926_b() && tool1.func_77973_b() == tool2.func_77973_b() && (ReplaceToolHeadRecipe.isToolAndToolHead(tool1, tool2) || ReplaceToolHeadRecipe.isToolAndToolHead(tool2, tool1));
    }

    private static boolean isToolAndToolHead(ItemStack tool, ItemStack toolHead) {
        PartDataList toolParts = GearData.getConstructionParts(tool);
        if (toolParts.isEmpty() || ReplaceToolHeadRecipe.isToolHead(toolParts)) {
            return false;
        }
        PartDataList toolHeadParts = GearData.getConstructionParts(toolHead);
        return !toolHeadParts.isEmpty() && ReplaceToolHeadRecipe.isToolHead(toolHeadParts);
    }

    private static boolean isToolHead(PartDataList parts) {
        return parts.stream().allMatch(p -> {
            PartType type = p.getType();
            return type == PartType.MAIN || type == PartType.TIP || type == PartType.HIGHLIGHT;
        });
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack tool = ItemStack.field_190927_a;
        ItemStack toolHead = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICoreTool)) continue;
            PartDataList parts = GearData.getConstructionParts(stack);
            if (ReplaceToolHeadRecipe.isToolHead(parts)) {
                toolHead = stack;
                continue;
            }
            tool = stack;
        }
        PartDataList toolParts = GearData.getConstructionParts(tool);
        PartDataList headParts = GearData.getConstructionParts(toolHead);
        List<PartData> oldHead = toolParts.getMains();
        List<PartData> newHead = headParts.getMains();
        toolParts.removeAll(oldHead);
        toolParts.addAll((Collection<? extends PartData>)newHead);
        ItemStack result = tool.func_77946_l();
        GearData.writeConstructionParts(result, toolParts);
        GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
        result.func_196085_b(toolHead.func_77952_i());
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            PartDataList parts = GearData.getConstructionParts(stack);
            if (ReplaceToolHeadRecipe.isToolHead(parts)) {
                list.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            ItemStack toolHead = StackList.from((IInventory)inv).uniqueMatch(s -> ReplaceToolHeadRecipe.isToolHead(GearData.getConstructionParts(s)));
            ItemStack copy = toolHead.func_77946_l();
            parts.removeIf(p -> p.getType() != PartType.MAIN);
            GearData.writeConstructionParts(copy, parts);
            GearData.recalculateStats(copy, ForgeHooks.getCraftingPlayer());
            copy.func_196085_b(stack.func_77952_i());
            list.set(i, (Object)copy);
        }
        return list;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

