/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.CrimsonIronOre;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.block.NetherwoodLeaves;
import net.silentchaos512.gear.block.NetherwoodLog;
import net.silentchaos512.gear.block.NetherwoodPlanks;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.NetherwoodSlab;
import net.silentchaos512.gear.block.NetherwoodStairs;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.StoneTorch;
import net.silentchaos512.gear.block.StoneTorchWall;
import net.silentchaos512.gear.block.analyzer.PartAnalyzerBlock;
import net.silentchaos512.gear.block.craftingstation.CraftingStationBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.utils.Lazy;

public enum ModBlocks implements IBlockProvider,
IStringSerializable
{
    CRAFTING_STATION(CraftingStationBlock::new),
    PART_ANALYZER(PartAnalyzerBlock::new),
    SALVAGER(SalvagerBlock::new),
    FLAX_PLANT(() -> new FlaxPlant(false), () -> null),
    WILD_FLAX_PLANT(() -> new FlaxPlant(true), () -> null),
    STONE_TORCH(StoneTorch::new, ModBlocks::getStoneTorchItem),
    WALL_STONE_TORCH(StoneTorchWall::new, () -> null),
    NETHERWOOD_LOG(NetherwoodLog::new),
    NETHERWOOD_PLANKS(NetherwoodPlanks::new),
    NETHERWOOD_SLAB(NetherwoodSlab::new),
    NETHERWOOD_STAIRS(NetherwoodStairs::new),
    NETHERWOOD_LEAVES(NetherwoodLeaves::new),
    NETHERWOOD_SAPLING(NetherwoodSapling::new),
    CRIMSON_IRON_ORE(CrimsonIronOre::new),
    POTTED_NETHERWOOD_SAPLING(() -> ModBlocks.makePottedPlant(NETHERWOOD_SAPLING), () -> null),
    PHANTOM_LIGHT(PhantomLight::new);

    private final Lazy<Block> block;
    private final Lazy<BlockItem> item;

    private ModBlocks(Supplier<Block> blockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(() -> new BlockItem(this.asBlock(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
    }

    private ModBlocks(Supplier<Block> blockSupplier, Supplier<BlockItem> itemBlockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(itemBlockSupplier);
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        if (!event.getName().equals((Object)ForgeRegistries.BLOCKS.getRegistryName())) {
            return;
        }
        for (ModBlocks block : ModBlocks.values()) {
            ModBlocks.register(block.func_176610_l(), block.asBlock(), (BlockItem)block.item.get());
        }
    }

    private static void register(String name, Block block, @Nullable BlockItem item) {
        ResourceLocation registryName = new ResourceLocation("silentgear", name);
        block.setRegistryName(registryName);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (item != null) {
            ModItems.blocksToRegister.put(name, item);
        }
    }

    private static BlockItem getStoneTorchItem() {
        return new WallOrFloorItem(STONE_TORCH.asBlock(), WALL_STONE_TORCH.asBlock(), new Item.Properties());
    }

    private static FlowerPotBlock makePottedPlant(IBlockProvider flower) {
        return new FlowerPotBlock(flower.asBlock(), Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }
}

