/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.renderer.entity.RenderSlingshotProjectile;
import net.silentchaos512.gear.entity.projectile.SlingshotProjectile;
import net.silentchaos512.utils.Lazy;

public enum ModEntities {
    SLINGSHOT_PROJECTILE(() -> EntityType.Builder.func_220322_a(SlingshotProjectile::new, (EntityClassification)EntityClassification.MISC));

    private final Lazy<EntityType<?>> entityType = Lazy.of(() -> {
        ResourceLocation id = SilentGear.getId(this.getName());
        return ((EntityType.Builder)factory.get()).func_206830_a(id.toString());
    });

    private ModEntities(Supplier<EntityType.Builder<?>> factory) {
    }

    public EntityType<?> type() {
        return (EntityType)this.entityType.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static void registerAll(RegistryEvent.Register<EntityType<?>> event) {
        if (!event.getRegistry().getRegistryName().equals((Object)ForgeRegistries.ENTITIES.getRegistryName())) {
            return;
        }
        for (ModEntities entity : ModEntities.values()) {
            EntityType<?> type = entity.type();
            type.setRegistryName(SilentGear.getId(entity.getName()));
            ForgeRegistries.ENTITIES.register(type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(SlingshotProjectile.class, (IRenderFactory)new RenderSlingshotProjectile.Factory());
    }
}

