/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomTippedUpgrade;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.item.gear.CoreDagger;
import net.silentchaos512.gear.item.gear.CoreExcavator;
import net.silentchaos512.gear.item.gear.CoreHammer;
import net.silentchaos512.gear.item.gear.CoreKatana;
import net.silentchaos512.gear.item.gear.CoreLumberAxe;
import net.silentchaos512.gear.item.gear.CoreMachete;
import net.silentchaos512.gear.item.gear.CoreMattock;
import net.silentchaos512.gear.item.gear.CorePickaxe;
import net.silentchaos512.gear.item.gear.CoreShield;
import net.silentchaos512.gear.item.gear.CoreShovel;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSlingshot;
import net.silentchaos512.gear.item.gear.CoreSpear;
import net.silentchaos512.gear.item.gear.CoreSword;

public final class ModItems {
    public static final Map<String, ICoreTool> toolClasses = new LinkedHashMap<String, ICoreTool>();
    public static final Map<String, ICoreArmor> armorClasses = new LinkedHashMap<String, ICoreArmor>();
    public static final Map<String, ICoreItem> gearClasses = new LinkedHashMap<String, ICoreItem>();
    public static final List<GearBlueprintItem> blueprints = new ArrayList<GearBlueprintItem>();
    static final Map<String, BlockItem> blocksToRegister = new LinkedHashMap<String, BlockItem>();
    public static BlueprintPackageItem blueprintPackage;
    public static CustomTippedUpgrade customTippedUpgrade;
    public static BlockNamedItem flaxseeds;
    public static Item netherBanana;
    public static Item pebble;
    public static CoreSword sword;
    public static CoreDagger dagger;
    public static CoreKatana katana;
    public static CoreMachete machete;
    public static CoreSpear spear;
    public static CorePickaxe pickaxe;
    public static CoreShovel shovel;
    public static CoreAxe axe;
    public static CoreHammer hammer;
    public static CoreExcavator excavator;
    public static CoreLumberAxe lumberAxe;
    public static CoreMattock mattock;
    public static CoreSickle sickle;
    public static CoreBow bow;
    public static CoreCrossbow crossbow;
    public static CoreSlingshot slingshot;
    public static CoreShield shield;
    public static CoreArmor helmet;
    public static CoreArmor chestplate;
    public static CoreArmor leggings;
    public static CoreArmor boots;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ITEMS.getRegistryName())) {
            return;
        }
        blocksToRegister.forEach(ModItems::register);
        ModItems.initializeGear();
        blueprintPackage = ModItems.register("blueprint_package", new BlueprintPackageItem(SilentGear.getId("starter_blueprints")));
        ModItems.registerBlueprints("blueprint", false);
        ModItems.registerBlueprints("template", true);
        for (CraftingItems item2 : CraftingItems.values()) {
            ModItems.register(item2.func_176610_l(), item2.func_199767_j());
        }
        ModItems.register("custom_tipped_upgrade", customTippedUpgrade);
        flaxseeds = ModItems.register("flaxseeds", new BlockNamedItem(ModBlocks.FLAX_PLANT.asBlock(), ModItems.getBaseProperties()));
        netherBanana = ModItems.register("nether_banana", new Item(ModItems.getBaseProperties().func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.4f).func_221453_d())));
        gearClasses.forEach((key, item) -> ModItems.register(key, item.func_199767_j()));
    }

    private static Item.Properties getBaseProperties() {
        return new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP);
    }

    private static void initializeGear() {
        toolClasses.put("sword", sword);
        toolClasses.put("dagger", dagger);
        toolClasses.put("katana", katana);
        toolClasses.put("machete", machete);
        toolClasses.put("spear", spear);
        toolClasses.put("pickaxe", pickaxe);
        toolClasses.put("shovel", shovel);
        toolClasses.put("axe", axe);
        toolClasses.put("hammer", hammer);
        toolClasses.put("excavator", excavator);
        toolClasses.put("lumber_axe", lumberAxe);
        toolClasses.put("mattock", mattock);
        toolClasses.put("sickle", sickle);
        toolClasses.put("bow", bow);
        toolClasses.put("crossbow", crossbow);
        armorClasses.put("helmet", helmet);
        armorClasses.put("chestplate", chestplate);
        armorClasses.put("leggings", leggings);
        armorClasses.put("boots", boots);
        gearClasses.putAll(toolClasses);
        gearClasses.putAll(armorClasses);
    }

    private static <T extends Item> T register(String name, T item) {
        ResourceLocation id = new ResourceLocation("silentgear", name);
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    private static void registerBlueprints(String name, boolean singleUse) {
        gearClasses.forEach((key, item) -> {
            GearBlueprintItem blueprint = new GearBlueprintItem(singleUse, (ICoreItem)item);
            blueprints.add(blueprint);
            ModItems.register(name + "_" + key, blueprint);
        });
        ModItems.register(name + "_rod", new PartBlueprintItem(singleUse, PartType.ROD));
        ModItems.register(name + "_bowstring", new PartBlueprintItem(singleUse, PartType.BOWSTRING));
    }

    static {
        customTippedUpgrade = new CustomTippedUpgrade();
        sword = new CoreSword();
        dagger = new CoreDagger();
        katana = new CoreKatana();
        machete = new CoreMachete();
        spear = new CoreSpear();
        pickaxe = new CorePickaxe();
        shovel = new CoreShovel();
        axe = new CoreAxe();
        hammer = new CoreHammer();
        excavator = new CoreExcavator();
        lumberAxe = new CoreLumberAxe();
        mattock = new CoreMattock();
        sickle = new CoreSickle();
        bow = new CoreBow();
        crossbow = new CoreCrossbow();
        slingshot = new CoreSlingshot();
        shield = new CoreShield();
        helmet = new CoreArmor(EquipmentSlotType.HEAD, "helmet");
        chestplate = new CoreArmor(EquipmentSlotType.CHEST, "chestplate");
        leggings = new CoreArmor(EquipmentSlotType.LEGS, "leggings");
        boots = new CoreArmor(EquipmentSlotType.FEET, "boots");
        ModItems.initializeGear();
    }
}

