/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.block.analyzer.PartAnalyzerTileEntity;
import net.silentchaos512.gear.block.craftingstation.CraftingStationTileEntity;
import net.silentchaos512.gear.block.salvager.SalvagerTileEntity;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.utils.Lazy;

public enum ModTileEntities {
    CRAFTING_STATION(CraftingStationTileEntity::new, ModBlocks.CRAFTING_STATION::asBlock),
    PART_ANALYZER(PartAnalyzerTileEntity::new, ModBlocks.PART_ANALYZER::asBlock),
    SALVAGER(SalvagerTileEntity::new, ModBlocks.SALVAGER::asBlock);

    private final Lazy<TileEntityType<?>> type = Lazy.of(() -> TileEntityType.Builder.func_223042_a((Supplier)tileEntitySupplier, (Block[])new Block[]{(Block)blockSupplier.get()}).func_206865_a(null));

    private ModTileEntities(Supplier<TileEntity> tileEntitySupplier, Supplier<Block> blockSupplier) {
    }

    public TileEntityType<?> type() {
        return (TileEntityType)this.type.get();
    }

    public static void registerAll(RegistryEvent.Register<TileEntityType<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.TILE_ENTITIES.getRegistryName())) {
            return;
        }
        for (ModTileEntities tileEnum : ModTileEntities.values()) {
            ModTileEntities.register(tileEnum.name().toLowerCase(Locale.ROOT), tileEnum.type());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
    }

    private static <T extends TileEntity> void register(String name, TileEntityType<T> type) {
        ResourceLocation id = new ResourceLocation("silentgear", name);
        type.setRegistryName(id);
        ForgeRegistries.TILE_ENTITIES.register(type);
    }
}

