/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.item.gear.CoreAxe;

public class CoreLumberAxe
extends CoreAxe {
    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(6.0f));
        }
        if (stat == ItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-3.3f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(0.5f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == ItemStats.DURABILITY) {
            return Optional.of(StatInstance.makeGearMod(1.0f));
        }
        if (stat == ItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.5f));
        }
        if (stat == ItemStats.HARVEST_SPEED) {
            return Optional.of(StatInstance.makeGearMod(-0.75f));
        }
        return Optional.empty();
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (state.func_203425_a(BlockTags.field_200031_h) && CoreLumberAxe.detectTree((IBlockReader)world, x, y, z, state.func_177230_c())) {
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
            TreeBreakResult result = new TreeBreakResult();
            this.breakTree(result, world, x, y, z, x, y, z, stack, state, player);
            return true;
        }
        return false;
    }

    private static boolean detectTree(IBlockReader world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_180495_p(new BlockPos(x, ++height, z)).func_177230_c()) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        BlockPos pos = new BlockPos(xPos, yPos, zPos);
                        BlockState leaves = world.func_180495_p(pos);
                        if (!leaves.func_203425_a(BlockTags.field_206952_E)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    private void breakTree(TreeBreakResult result, World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack tool, BlockState state, PlayerEntity player) {
        Block block = state.func_177230_c();
        BlockPos pos = new BlockPos(x, y, z);
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    BlockPos localPos = new BlockPos(xPos, yPos, zPos);
                    BlockState localState = world.func_180495_p(localPos);
                    Block localBlock = localState.func_177230_c();
                    if (block != localBlock) continue;
                    int harvestLevel = localBlock.getHarvestLevel(localState);
                    float localHardness = localState.func_185887_b((IBlockReader)world, localPos);
                    if (harvestLevel > this.getHarvestLevel(tool, ToolType.AXE, player, localState) || !(localHardness >= 0.0f)) continue;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, localPos, localState, player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    boolean cancel = event.isCanceled();
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500) continue;
                    if (cancel) {
                        this.breakTree(result, world, xPos, yPos, zPos, xStart, yStart, zStart, tool, state, player);
                        continue;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_180657_a(world, player, pos, state, world.func_175625_s(pos), tool);
                        this.func_179218_a(tool, world, localState, localPos, (LivingEntity)player);
                        ++result.blocksBroken;
                    }
                    world.func_217377_a(localPos, false);
                    if (world.field_72995_K) continue;
                    this.breakTree(result, world, xPos, yPos, zPos, xStart, yStart, zStart, tool, state, player);
                }
            }
        }
    }

    private static class TreeBreakResult {
        int blocksBroken;

        private TreeBreakResult() {
        }
    }
}

