/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.EnumUtils;

public final class PartDisplay
implements IPartDisplay {
    public static final PartDisplay DEFAULT = new PartDisplay();
    private String textureDomain;
    private String textureSuffix;
    private int normalColor;
    private int brokenColor;
    private int fallbackColor;
    private boolean highlight;
    private PartTextureType liteTexture = PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT;

    PartDisplay() {
        this.textureDomain = "silentgear";
        this.textureSuffix = "";
        this.fallbackColor = 0xFFFFFF;
        this.brokenColor = 0xFFFFFF;
        this.normalColor = 0xFFFFFF;
    }

    public PartDisplay(String textureDomain, String textureSuffix) {
        this(textureDomain, textureSuffix, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF);
    }

    public PartDisplay(String textureDomain, String textureSuffix, int normalColor, int brokenColor, int fallbackColor) {
        this.textureDomain = textureDomain;
        this.textureSuffix = textureSuffix;
        this.normalColor = normalColor;
        this.brokenColor = brokenColor;
        this.fallbackColor = fallbackColor;
    }

    @Override
    public String getTextureDomain() {
        return this.textureDomain;
    }

    @Override
    public String getTextureSuffix() {
        return this.textureSuffix;
    }

    @Override
    public int getNormalColor() {
        return this.normalColor;
    }

    @Override
    public int getBrokenColor() {
        return this.brokenColor;
    }

    @Override
    public int getFallbackColor() {
        return this.fallbackColor;
    }

    @Override
    public boolean hasHighlight() {
        return this.highlight;
    }

    @Override
    public PartTextureType getLiteTexture() {
        return this.liteTexture;
    }

    public static PartDisplay from(JsonObject json, IPartDisplay defaultProps) {
        String textureDomain = JSONUtils.func_151219_a((JsonObject)json, (String)"texture_domain", (String)defaultProps.getTextureDomain());
        String textureSuffix = JSONUtils.func_151219_a((JsonObject)json, (String)"texture_suffix", (String)defaultProps.getTextureSuffix());
        int normalColor = PartDisplay.loadColor(json, defaultProps.getNormalColor(), defaultProps.getNormalColor(), "normal_color", "texture_color");
        int brokenColor = PartDisplay.loadColor(json, defaultProps.getBrokenColor(), normalColor, "broken_color");
        int fallbackColor = PartDisplay.loadColor(json, defaultProps.getFallbackColor(), brokenColor, "fallback_color");
        PartDisplay props = new PartDisplay(textureDomain, textureSuffix, normalColor, brokenColor, fallbackColor);
        props.highlight = JSONUtils.func_151209_a((JsonObject)json, (String)"highlight", (boolean)props.highlight);
        props.liteTexture = (PartTextureType)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"lite_texture", (String)""), (Enum)props.liteTexture);
        return props;
    }

    private static int loadColor(JsonObject json, int defaultValue, int fallback, String ... keys) {
        for (String key : keys) {
            if (!json.has(key)) continue;
            return Color.from((JsonObject)json, (String)key, (int)defaultValue).getColor();
        }
        return fallback;
    }

    public static PartDisplay read(PacketBuffer buffer) {
        PartDisplay display = new PartDisplay();
        display.textureDomain = buffer.func_150789_c(255);
        display.textureSuffix = buffer.func_150789_c(32676);
        display.normalColor = buffer.func_150792_a();
        display.brokenColor = buffer.func_150792_a();
        display.fallbackColor = buffer.func_150792_a();
        display.highlight = buffer.readBoolean();
        display.liteTexture = (PartTextureType)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT);
        return display;
    }

    public static void write(PacketBuffer buffer, PartDisplay display) {
        buffer.func_180714_a(display.textureDomain);
        buffer.func_180714_a(display.textureSuffix);
        buffer.func_150787_b(display.normalColor);
        buffer.func_150787_b(display.brokenColor);
        buffer.func_150787_b(display.fallbackColor);
        buffer.writeBoolean(display.highlight);
        buffer.writeByte(display.liteTexture.getIndex());
    }

    public String toString() {
        return "PartDisplay{textureDomain='" + this.textureDomain + '\'' + ", textureSuffix='" + this.textureSuffix + '\'' + ", normalColor=" + Integer.toHexString(this.normalColor) + ", brokenColor=" + Integer.toHexString(this.brokenColor) + ", fallbackColor=" + Integer.toHexString(this.fallbackColor) + ", highlight=" + this.highlight + '}';
    }
}

