/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartManager;

public final class PartSerializers {
    private static final Map<ResourceLocation, IPartSerializer<?>> REGISTRY = new HashMap();

    private PartSerializers() {
    }

    public static <S extends IPartSerializer<T>, T extends IGearPart> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate gear part serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(PartManager.MARKER, "Registered serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IGearPart deserialize(ResourceLocation id, JsonObject json) {
        String typeStr = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!typeStr.contains(":")) {
            typeStr = "silentgear:" + typeStr;
        }
        ResourceLocation type = new ResourceLocation(typeStr);
        PartSerializers.log(() -> "deserialize " + id + " (type " + type + ")");
        IPartSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Invalid or unsupported gear part type " + type);
        }
        return serializer.read(id, json);
    }

    public static IGearPart read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        PartSerializers.log(() -> "read " + id + " (type " + type + ")");
        IPartSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown gear part serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IGearPart> void write(T part, PacketBuffer buffer) {
        ResourceLocation id = part.getId();
        ResourceLocation type = part.getSerializer().getName();
        PartSerializers.log(() -> "write " + id + " (type " + type + ")");
        buffer.func_192572_a(id);
        buffer.func_192572_a(type);
        IPartSerializer<?> serializer = part.getSerializer();
        serializer.write(buffer, part);
    }

    private static void log(Supplier<?> msg) {
        if (((Boolean)Config.GENERAL.extraPartAndTraitLogging.get()).booleanValue()) {
            SilentGear.LOGGER.info(PartManager.MARKER, msg.get());
        }
    }

    static {
        for (PartType type : PartType.getValues()) {
            PartSerializers.register(type.getSerializer());
        }
    }
}

