/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.GearData;

public final class GearGenerator {
    private GearGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static Optional<IGearPart> selectRandom(GearType gearType, PartType type) {
        return GearGenerator.selectRandom(gearType, type, -1);
    }

    public static Optional<IGearPart> selectRandom(GearType gearType, PartType type, int partTier) {
        return GearGenerator.selectRandom(gearType, type, partTier, partTier);
    }

    public static Optional<IGearPart> selectRandom(GearType gearType, PartType type, int minTier, int maxTier) {
        List list = PartManager.getValues().stream().filter(p -> p.getType() == type && p.isCraftingAllowed(gearType)).filter(p -> minTier == -1 || p.getTier() >= minTier && p.getTier() <= maxTier).collect(Collectors.toList());
        if (!list.isEmpty()) {
            return Optional.of(list.get(SilentGear.random.nextInt(list.size())));
        }
        return Optional.ofNullable(PartManager.tryGetFallback(type));
    }

    public static Collection<IGearPart> selectRandomMains(GearType gearType, int count, int partTier) {
        ArrayList<IGearPart> list = new ArrayList<IGearPart>();
        for (int i = 0; i < count; ++i) {
            GearGenerator.selectRandom(gearType, PartType.MAIN, partTier).ifPresent(list::add);
        }
        return list;
    }

    public static ItemStack create(ICoreItem item, int minTier, int maxTier) {
        if (minTier >= maxTier) {
            return GearGenerator.create(item, maxTier);
        }
        return GearGenerator.create(item, minTier + SilentGear.random.nextInt(maxTier - minTier));
    }

    public static ItemStack create(ICoreItem item, int tier) {
        return GearGenerator.randomizeParts(new ItemStack((IItemProvider)item), tier);
    }

    public static ItemStack randomizeParts(ItemStack stack, int tier) {
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            throw new RuntimeException("Called GearGenerator.randomizeParts on non-gear");
        }
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        GearType gearType = item.getGearType();
        Collection<IGearPart> mains = GearGenerator.selectRandomMains(gearType, GearGenerator.getMainPartCount(), tier);
        Optional<IGearPart> rod = GearGenerator.selectRandom(gearType, PartType.ROD, 0, tier);
        if (mains.isEmpty() || !rod.isPresent()) {
            return ItemStack.field_190927_a;
        }
        PartDataList parts = PartDataList.of(new PartData[0]);
        mains.forEach(p -> parts.add(PartData.of(p)));
        if (item.requiresPartOfType(PartType.ROD)) {
            parts.addPart(rod.get());
        }
        if (item.requiresPartOfType(PartType.BOWSTRING)) {
            Optional<IGearPart> bowstring = GearGenerator.selectRandom(gearType, PartType.BOWSTRING, 0, tier);
            bowstring.ifPresent(parts::addPart);
        }
        ItemStack result = stack.func_77946_l();
        GearData.writeConstructionParts(result, parts);
        if (item instanceof ICoreTool && SilentGear.random.nextFloat() < 0.2f * (float)tier + 0.1f) {
            Optional<IGearPart> tip = GearGenerator.selectRandom(gearType, PartType.TIP);
            tip.ifPresent(part -> GearData.addUpgradePart(result, PartData.of(part)));
        }
        GearData.recalculateStats(result, null);
        return result;
    }

    public static int getMainPartCount() {
        int randomMultiplier = 45;
        int randomInt = SilentGear.random.nextInt(randomMultiplier);
        int k = 0;
        int i = 9;
        while (randomInt >= 0) {
            randomInt -= i;
            ++k;
            --i;
        }
        int result = k / 3;
        return result > 0 ? result : 1;
    }
}

