/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;

public interface IAOETool {
    @Nonnull
    public ToolType getAOEToolClass();

    @Nullable
    public RayTraceResult rayTraceBlocks(World var1, PlayerEntity var2);

    default public List<BlockPos> getExtraBlocks(World world, @Nullable BlockRayTraceResult rt, PlayerEntity player, ItemStack stack) {
        BlockState state;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (player.func_70093_af() || rt == null || rt.func_216350_a() == null || rt.func_216354_b() == null) {
            return positions;
        }
        BlockPos pos = rt.func_216350_a();
        if (this.isEffectiveOnBlock(stack, world, pos, state = world.func_180495_p(pos))) {
            switch (rt.func_216354_b().func_176740_k()) {
                case Y: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST).func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST).func_177972_a(Direction.NORTH), stack, positions);
                    break;
                }
                case X: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP).func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN).func_177972_a(Direction.NORTH), stack, positions);
                    break;
                }
                case Z: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN).func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST).func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP).func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST).func_177972_a(Direction.DOWN), stack, positions);
                }
            }
        }
        return positions;
    }

    default public boolean isEffectiveOnBlock(ItemStack stack, World world, BlockPos pos, BlockState state) {
        return stack.func_77973_b().canHarvestBlock(stack, state) || ForgeHooks.canToolHarvestBlock((IWorldReader)world, (BlockPos)pos, (ItemStack)stack);
    }

    default public void attemptAddExtraBlock(World world, BlockState state1, BlockPos pos2, ItemStack stack, List<BlockPos> list) {
        BlockState state2 = world.func_180495_p(pos2);
        if (state2.func_185887_b((IBlockReader)world, pos2) < 0.0f) {
            return;
        }
        if (!world.func_175623_d(pos2) && BreakHandler.areBlocksSimilar(state1, state2) && (state2.func_177230_c().isToolEffective(state2, this.getAOEToolClass()) || stack.func_77973_b().canHarvestBlock(stack, state2))) {
            list.add(pos2);
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
    public static final class HighlightHandler {
        private HighlightHandler() {
        }

        @SubscribeEvent
        public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
            ItemStack stack;
            ActiveRenderInfo info = event.getInfo();
            Entity entity = info.func_216773_g();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            RayTraceResult rt = event.getTarget();
            if (event.getSubID() == 0 && rt.func_216346_c() == RayTraceResult.Type.BLOCK && (stack = player.func_184614_ca()).func_77973_b() instanceof IAOETool) {
                World world = player.func_130014_f_();
                IAOETool item = (IAOETool)stack.func_77973_b();
                for (BlockPos pos : item.getExtraBlocks(world, (BlockRayTraceResult)rt, player, stack)) {
                    event.getContext().func_215325_a(info, (RayTraceResult)new BlockRayTraceResult(Vec3d.field_186680_a, Direction.UP, pos, false), 0);
                }
            }
        }
    }

    public static final class BreakHandler {
        private static final Set<Block> ORE_BLOCKS = new HashSet<Block>();

        private BreakHandler() {
        }

        public static boolean onBlockStartBreak(ItemStack tool, BlockPos pos, PlayerEntity player) {
            World world = player.func_130014_f_();
            if (world.field_72995_K || !(player instanceof ServerPlayerEntity) || !(tool.func_77973_b() instanceof IAOETool)) {
                return false;
            }
            IAOETool item = (IAOETool)tool.func_77973_b();
            RayTraceResult rt = item.rayTraceBlocks(world, player);
            BlockState stateOriginal = world.func_180495_p(pos);
            if (rt != null && rt.func_216346_c() == RayTraceResult.Type.BLOCK && item.isEffectiveOnBlock(tool, world, pos, stateOriginal)) {
                BlockRayTraceResult brt = (BlockRayTraceResult)rt;
                Direction side = brt.func_216354_b();
                List<BlockPos> extraBlocks = item.getExtraBlocks(world, brt, player, tool);
                for (BlockPos pos2 : extraBlocks) {
                    BlockState state = world.func_180495_p(pos2);
                    if (!world.func_175667_e(pos2) || !player.func_175151_a(pos2, side, tool) || !state.canHarvestBlock((IBlockReader)world, pos2, player)) continue;
                    if (player.field_71075_bZ.field_75098_d) {
                        if (state.removedByPlayer(world, pos2, player, true, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                        }
                    } else {
                        int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos2);
                        if (xp == -1) continue;
                        tool.func_77973_b().func_179218_a(tool, world, state, pos2, (LivingEntity)player);
                        TileEntity tileEntity = world.func_175625_s(pos2);
                        if (state.removedByPlayer(world, pos2, player, true, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                            state.func_177230_c().func_180657_a(world, player, pos2, state, tileEntity, tool);
                            state.func_177230_c().func_180637_b(world, pos2, xp);
                        }
                    }
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
                }
            }
            return false;
        }

        public static void buildOreBlocksSet() {
            ORE_BLOCKS.clear();
            for (Block block : ForgeRegistries.BLOCKS) {
                if (!(block instanceof OreBlock) && !Tags.Blocks.ORES.func_199685_a_((Object)block)) continue;
                ORE_BLOCKS.add(block);
            }
            SilentGear.LOGGER.info("IAOETool: Rebuilt ore block set, contains {} items", (Object)ORE_BLOCKS.size());
        }

        static boolean areBlocksSimilar(BlockState state1, BlockState state2) {
            int level2;
            MatchMode mode;
            Block block1 = state1.func_177230_c();
            Block block2 = state2.func_177230_c();
            boolean isOre1 = ORE_BLOCKS.contains(block1);
            boolean isOre2 = ORE_BLOCKS.contains(block2);
            MatchMode matchMode = mode = isOre1 && isOre2 ? (MatchMode)Config.GENERAL.matchModeOres.get() : (MatchMode)Config.GENERAL.matchModeStandard.get();
            if (mode == MatchMode.LOOSE || block1 == block2) {
                return true;
            }
            if (mode == MatchMode.STRICT || !isOre1 && isOre2) {
                return false;
            }
            int level1 = block1.getHarvestLevel(state1);
            return level1 >= (level2 = block2.getHarvestLevel(state2)) || level2 == 0;
        }
    }

    public static enum MatchMode {
        LOOSE,
        MODERATE,
        STRICT;

    }
}

