/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.world.feature.NetherwoodTreeFeature;
import net.silentchaos512.gear.world.placement.NetherFloorWithExtra;
import net.silentchaos512.gear.world.placement.NetherFloorWithExtraConfig;
import net.silentchaos512.lib.world.feature.PlantFeature;

public final class ModWorldFeatures {
    private ModWorldFeatures() {
    }

    public static void addFeaturesToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS || biome.func_201856_r() == Biome.Category.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        }
    }

    private static void addWildFlax(Biome biome) {
        SilentGear.LOGGER.info("Add wild flax to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new PlantFeature(((FlaxPlant)ModBlocks.WILD_FLAX_PLANT.asBlock()).getMaturePlant(), 32, 4), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    private static void addNetherwoodTrees(Biome biome) {
        SilentGear.LOGGER.info("Add netherwood trees to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new NetherwoodTreeFeature(true), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)NetherFloorWithExtra.INSTANCE, (IPlacementConfig)new NetherFloorWithExtraConfig(1, 0.25f, 11, 32, 96)));
    }

    private static void addCrimsonIronOre(Biome biome) {
        SilentGear.LOGGER.info("Add crimson iron ore to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 6), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(24, 24, 0, 120)));
    }
}

