/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world.feature;

import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModTags;

public class NetherwoodTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = ModBlocks.NETHERWOOD_LOG.asBlockState();
    private static final BlockState LEAF = ModBlocks.NETHERWOOD_LEAVES.asBlockState();

    public NetherwoodTreeFeature(boolean notify) {
        super(dynamic -> new NoFeatureConfig(), notify);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int height = rand.nextInt(5) + 5;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            int x;
            int y;
            boolean flag = true;
            for (y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int leavesReach = 2;
                if (y == position.func_177956_o()) {
                    leavesReach = 0;
                }
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
                for (x = position.func_177958_n() - leavesReach; x <= position.func_177958_n() + leavesReach && flag; ++x) {
                    for (int z = position.func_177952_p() - leavesReach; z <= position.func_177952_p() + leavesReach && flag; ++z) {
                        if (y >= 0 && y < worldIn.getMaxHeight()) {
                            if (NetherwoodTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockPos.func_181079_c(x, y, z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (NetherwoodTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (y = position.func_177956_o() + 2; y <= position.func_177956_o() + height; ++y) {
                    int dy = y - position.func_177956_o();
                    int leavesReach = dy > 3 ? 2 : 1;
                    for (x = position.func_177958_n() - leavesReach; x <= position.func_177958_n() + leavesReach; ++x) {
                        int dx = x - position.func_177958_n();
                        for (int z = position.func_177952_p() - leavesReach; z <= position.func_177952_p() + leavesReach; ++z) {
                            BlockPos blockpos;
                            int k1 = z - position.func_177952_p();
                            if (Math.abs(dx) == leavesReach && Math.abs(k1) == leavesReach && (rand.nextInt(2) == 0 || dy == 0) || !NetherwoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(x, y, z)))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, LEAF, p_208519_5_);
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!NetherwoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i2), LOG, p_208519_5_);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean isSoil(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        return reader.func_217375_a(pos, state -> state.func_203425_a(ModTags.Blocks.NETHERWOOD_SOIL));
    }

    protected void setDirtAt(IWorldGenerationReader reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof IWorld)) {
            return;
        }
        ((IWorld)reader).func_180495_p(pos).onPlantGrow((IWorld)reader, pos, origin);
    }

    private void tryPlaceLeaves(IWorld worldIn, BlockPos position, @Nullable Direction side) {
        BlockPos pos = side != null ? position.func_177972_a(side) : position;
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().canBeReplacedByLeaves(state, (IWorldReader)worldIn, pos)) {
            this.func_202278_a((IWorldWriter)worldIn, pos, LEAF);
        }
    }
}

