/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.IStatItem;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public interface ICoreItem
extends IItemProvider,
IStatItem {
    default public ItemStack construct(Collection<? extends IPartData> parts) {
        ItemStack result = new ItemStack((IItemProvider)this);
        GearData.writeConstructionParts(result, parts);
        parts.forEach(p -> p.onAddToGear(result));
        GearData.recalculateStats(result, null);
        TraitHelper.activateTraits(result, 0.0f, (trait, level, nothing) -> {
            trait.onGearCrafted(new TraitActionContext(null, level, result));
            return 0.0f;
        });
        return result;
    }

    default public Item func_199767_j() {
        return (Item)this;
    }

    public GearType getGearType();

    @Deprecated
    default public PartData getPrimaryPart(ItemStack stack) {
        PartData data = GearData.getPrimaryPart(stack);
        if (data != null) {
            return data;
        }
        return Objects.requireNonNull(PartData.ofNullable(PartType.MAIN.getFallbackPart()));
    }

    default public boolean requiresPartOfType(PartType type) {
        return type == PartType.MAIN;
    }

    default public boolean supportsPartOfType(PartType type) {
        return this.requiresPartOfType(type) || type == PartType.BINDING || type == PartType.GRIP || type == PartType.MISC_UPGRADE || type == PartType.TIP;
    }

    @Override
    default public float getStat(ItemStack stack, ItemStat stat) {
        return GearData.getStat(stack, stat);
    }

    public Set<ItemStat> getRelevantStats(ItemStack var1);

    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return Collections.emptySet();
    }

    default public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    default public Optional<StatInstance> getStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    default public ItemStat getDurabilityStat() {
        return ItemStats.DURABILITY;
    }

    default public int getAnimationFrames() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public IItemColor getItemColors() {
        return (stack, tintIndex) -> 0xFFFFFF;
    }

    @Deprecated
    default public String getModelKey(ItemStack stack, int animationFrame, PartData ... parts) {
        StringBuilder builder = new StringBuilder(this.getGearType().getName());
        if (GearHelper.isBroken(stack)) {
            builder.append("_b");
        }
        boolean foundMain = false;
        for (PartData part : parts) {
            if (part.getType() == PartType.MAIN) {
                if (foundMain) continue;
                foundMain = true;
                builder.append("|").append(part.getModelIndex(animationFrame));
                continue;
            }
            builder.append("|").append(part.getModelIndex(animationFrame));
        }
        return builder.toString();
    }

    @Deprecated
    default public String getModelKey(ItemStack stack, int animationFrame) {
        return this.getModelKey(stack, animationFrame, this.getRenderParts(stack));
    }

    @Deprecated
    public PartData[] getRenderParts(ItemStack var1);
}

