/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.parts.PartTextureType;

public interface IMaterial {
    public String getPackName();

    public ResourceLocation getId();

    public int getTier(PartType var1);

    public Ingredient getIngredient(PartType var1);

    public boolean allowedInPart(PartType var1);

    public void retainData(@Nullable IMaterial var1);

    public Collection<StatInstance> getStatModifiers(ItemStat var1, PartType var2, ItemStack var3);

    default public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType) {
        return this.getStatModifiers(stat, partType, ItemStack.field_190927_a);
    }

    public Collection<PartTraitInstance> getTraits(PartType var1, ItemStack var2);

    default public Collection<PartTraitInstance> getTraits(PartType partType) {
        return this.getTraits(partType, ItemStack.field_190927_a);
    }

    default public float getStat(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, this.getStatModifiers(stat, partType));
    }

    default public float getStatUnclamped(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, false, this.getStatModifiers(stat, partType));
    }

    @Deprecated
    default public boolean isCraftingAllowed(ICoreItem item, PartType partType) {
        if (partType == PartType.MAIN) {
            return this.getStatUnclamped(item.getDurabilityStat(), partType) > 0.0f;
        }
        return true;
    }

    default public boolean isCraftingAllowed(PartType partType) {
        return true;
    }

    public int getColor(ItemStack var1, PartType var2);

    public PartTextureType getTexture(PartType var1, ItemStack var2);

    public ITextComponent getDisplayName(PartType var1, ItemStack var2);

    default public ITextComponent getDisplayName(PartType partType) {
        return this.getDisplayName(partType, ItemStack.field_190927_a);
    }

    @Nullable
    default public ITextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return null;
    }

    default public boolean isVisible(PartType partType) {
        return true;
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient(type).func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[ticks / 20 % stacks.length];
    }

    public void updateIngredient(SyncMaterialCraftingItemsPacket var1);
}

