/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.traits.ITraitCondition;

@FunctionalInterface
public interface ITraitConditionSerializer {
    public static final ITraitConditionSerializer NOT = ITraitConditionSerializer.register(SilentGear.getId("not"), json -> {
        ITraitCondition child = ITraitConditionSerializer.getCondition(JSONUtils.func_152754_s((JsonObject)json, (String)"value"));
        return (gear, parts, trait) -> !child.matches(gear, parts, trait);
    });
    public static final ITraitConditionSerializer OR = ITraitConditionSerializer.register(SilentGear.getId("or"), json -> {
        JsonArray values = JSONUtils.func_151214_t((JsonObject)json, (String)"values");
        ArrayList<ITraitCondition> children = new ArrayList<ITraitCondition>();
        for (JsonElement j : values) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
            }
            children.add(ITraitConditionSerializer.getCondition(j.getAsJsonObject()));
        }
        return (gear, parts, trait) -> children.stream().anyMatch(condition -> condition.matches(gear, parts, trait));
    });
    public static final ITraitConditionSerializer AND = ITraitConditionSerializer.register(SilentGear.getId("and"), json -> {
        JsonArray values = JSONUtils.func_151214_t((JsonObject)json, (String)"values");
        ArrayList<ITraitCondition> children = new ArrayList<ITraitCondition>();
        for (JsonElement j : values) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
            }
            children.add(ITraitConditionSerializer.getCondition(j.getAsJsonObject()));
        }
        return (gear, parts, trait) -> children.stream().allMatch(condition -> condition.matches(gear, parts, trait));
    });
    public static final ITraitConditionSerializer GEAR_TYPE = ITraitConditionSerializer.register(SilentGear.getId("gear_type"), json -> {
        String gearType = JSONUtils.func_151200_h((JsonObject)json, (String)"gear_type");
        return (gear, parts, trait) -> {
            if (gear.func_190926_b() || !(gear.func_77973_b() instanceof ICoreItem)) {
                return false;
            }
            return ((ICoreItem)gear.func_77973_b()).getGearType().matches(gearType);
        };
    });
    public static final ITraitConditionSerializer MATERIAL_COUNT = ITraitConditionSerializer.register(SilentGear.getId("material_count"), json -> {
        int count = JSONUtils.func_151203_m((JsonObject)json, (String)"count");
        return (gear, parts, trait) -> {
            int partsWithTrait = parts.getPartsWithTrait(trait);
            return partsWithTrait >= count;
        };
    });
    public static final ITraitConditionSerializer MATERIAL_RATIO = ITraitConditionSerializer.register(SilentGear.getId("material_ratio"), json -> {
        float ratio = JSONUtils.func_151217_k((JsonObject)json, (String)"ratio");
        return (gear, parts, trait) -> {
            float ratioInGear = (float)parts.getPartsWithTrait(trait) / (float)parts.getMains().size();
            return ratioInGear >= ratio;
        };
    });

    public ITraitCondition parse(JsonObject var1);

    public static ITraitConditionSerializer register(ResourceLocation id, ITraitConditionSerializer serializer) {
        if (Helper.CONDITIONS.containsKey(id)) {
            throw new IllegalArgumentException("Already have trait condition serializer with ID '" + id + "'");
        }
        if (SilentGear.LOGGER.isDebugEnabled()) {
            SilentGear.LOGGER.debug("Register ITraitConditionSerializer '{}'", (Object)id);
        }
        Helper.CONDITIONS.put(id, serializer);
        return serializer;
    }

    public static ITraitCondition getCondition(JsonObject json) {
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
        ITraitConditionSerializer serializer = (ITraitConditionSerializer)Helper.CONDITIONS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown trait condition type: " + type);
        }
        return serializer.parse(json);
    }

    public static final class Helper {
        private static final Map<ResourceLocation, ITraitConditionSerializer> CONDITIONS = new HashMap<ResourceLocation, ITraitConditionSerializer>();

        private Helper() {
        }
    }
}

