/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.grader;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class GraderTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    static final int BASE_ANALYZE_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 1.0f : 5.0f));
    private static final List<Tag<Item>> CATALYST_TAGS = ImmutableList.of((Object)new ItemTags.Wrapper(SilentGear.getId("grader_catalysts/tier1")), (Object)new ItemTags.Wrapper(SilentGear.getId("grader_catalysts/tier2")), (Object)new ItemTags.Wrapper(SilentGear.getId("grader_catalysts/tier3")), (Object)new ItemTags.Wrapper(SilentGear.getId("grader_catalysts/tier4")), (Object)new ItemTags.Wrapper(SilentGear.getId("grader_catalysts/tier5")));
    static final int INPUT_SLOT = 0;
    static final int CATALYST_SLOT = 1;
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{2, 3, 4, 5};
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, INVENTORY_SIZE).toArray();
    @SyncVariable(name="progress")
    private int progress = 0;
    private boolean requireClientSync = false;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            return GraderTileEntity.this.progress;
        }

        public void func_221477_a(int index, int value) {
            GraderTileEntity.this.progress = value;
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public GraderTileEntity() {
        super(ModTileEntities.MATERIAL_GRADER.type(), INVENTORY_SIZE);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        ItemStack input = this.getInputStack();
        if (input.func_190926_b()) {
            return;
        }
        int outputSlot = this.getFreeOutputSlot();
        if (outputSlot < 0) {
            return;
        }
        ItemStack catalyst = this.getCatalystStack();
        int catalystTier = GraderTileEntity.getCatalystTier(catalyst);
        if (catalystTier < 1) {
            return;
        }
        MaterialInstance material = MaterialInstance.from(input);
        if (material != null && material.getGrade() != MaterialGrade.SSS) {
            if (this.progress < BASE_ANALYZE_TIME) {
                ++this.progress;
            }
            if (this.progress >= BASE_ANALYZE_TIME && !this.field_145850_b.field_72995_K) {
                this.progress = 0;
                catalyst.func_190918_g(1);
                this.tryGradeItem(input, catalystTier, material);
            }
        } else {
            this.progress = 0;
        }
    }

    private void tryGradeItem(ItemStack input, int catalystTier, IMaterialInstance material) {
        MaterialGrade targetGrade = MaterialGrade.selectWithCatalyst(SilentGear.random, catalystTier);
        if (targetGrade.ordinal() > material.getGrade().ordinal()) {
            ItemStack stack = input.func_77979_a(1);
            targetGrade.setGradeOnStack(stack);
            InventoryUtils.mergeItem((IInventory)this, (int)2, (int)(2 + SLOTS_OUTPUT.length), (ItemStack)stack);
        }
    }

    public boolean func_191420_l() {
        return this.getInputStack().func_190926_b();
    }

    private ItemStack getInputStack() {
        MaterialInstance material;
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && (material = MaterialInstance.from(stack)) != null && material.getGrade() != MaterialGrade.SSS) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getCatalystStack() {
        return this.func_70301_a(1);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    static boolean canAcceptInput(ItemStack stack) {
        MaterialInstance material = MaterialInstance.from(stack);
        return material != null && material.getGrade() != MaterialGrade.SSS;
    }

    static int getCatalystTier(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (int i = CATALYST_TAGS.size() - 1; i >= 0; --i) {
                if (!stack.func_77973_b().func_206844_a(CATALYST_TAGS.get(i))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        CompoundNBT compoundTag = super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)compoundTag, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return compoundTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tags = this.func_189517_E_();
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            CompoundNBT itemTags = input.serializeNBT();
            tags.func_218657_a("input_item", (INBT)itemTags);
        }
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tags);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        ListNBT tagList = new ListNBT();
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            CompoundNBT itemTags = input.serializeNBT();
            itemTags.func_74774_a("Slot", (byte)0);
            tagList.add((Object)itemTags);
        }
        tags.func_218657_a("Items", (INBT)tagList);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
        if (tags.func_74764_b("input_item")) {
            this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)tags.func_74775_l("input_item")));
        } else {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_INPUT;
            }
            case DOWN: {
                return SLOTS_OUTPUT;
            }
        }
        return SLOTS_ALL;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 0 && index != 1) {
            return false;
        }
        ItemStack stackInSlot = this.func_70301_a(index);
        if (stack.func_190926_b() || !stackInSlot.func_190926_b() && !stackInSlot.func_77969_a(stack)) {
            return false;
        }
        if (index == 0) {
            return GraderTileEntity.canAcceptInput(stack);
        }
        return GraderTileEntity.getCatalystTier(stack) > 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index != 0 && index != 1;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgear.material_grader", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new GraderContainer(id, playerInventory, (IInventory)this, this.fields);
    }
}

