/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.TextRenderUtils;

public class GuiItemParts
extends Screen {
    private static final int BUTTON_SPACING = 20;
    private static final int BUTTON_ROW_LENGTH = 12;
    private static final int BUTTON_INITIAL_OFFSET = 5;
    private List<IGearPart> partList = new ArrayList<IGearPart>();
    private List<PartButton> partButtons = new ArrayList<PartButton>();
    private IGearPart selectedPart = null;
    private List<Tuple<String, String>> selectedPartInfo = null;

    public GuiItemParts(ITextComponent p_i51108_1_) {
        super(p_i51108_1_);
    }

    public void init() {
        if (this.minecraft == null) {
            return;
        }
        ArrayList<Pair<String, Button.IPressable>> sortOptions = new ArrayList<Pair<String, Button.IPressable>>();
        sortOptions.add(new Pair((Object)"Name", b -> this.sortParts(false, Comparator.comparing(p -> p.getDisplayName(null, ItemStack.field_190927_a).func_150254_d()))));
        sortOptions.add(new Pair((Object)"Type", b -> this.sortParts(false, Comparator.comparing(p -> p.getType().getName()))));
        ItemStats.allStatsOrdered().stream().filter(ItemStat::isVisible).forEachOrdered(stat -> sortOptions.add(new Pair((Object)stat.getDisplayName().func_150254_d(), b -> this.sortParts(true, Comparator.comparing(p -> Float.valueOf(p.computeStatValue((ItemStat)((Object)stat))))))));
        this.addButton((Widget)new SortButton(5, this.minecraft.func_228018_at_().func_198087_p() - 30, 100, 20, sortOptions));
        int i = 0;
        for (IGearPart part : PartManager.getValues()) {
            if (!part.isCraftingAllowed(null) || !part.isVisible()) continue;
            this.partList.add(part);
            int x = i % 12;
            int y = i / 12;
            PartButton button = new PartButton(part, x * 20 + 5, y * 20 + 5, b -> {
                this.selectedPart = part;
                this.selectedPartInfo = GuiItemParts.getPartInfo(this.selectedPart);
            });
            this.partButtons.add(button);
            this.addButton((Widget)button);
            ++i;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void layoutPartButtons() {
        int i = 0;
        for (PartButton button : this.partButtons) {
            button.x = i % 12 * 20 + 5;
            button.y = i / 12 * 20 + 5;
            ++i;
        }
    }

    private void sortParts(boolean reversed, Comparator<IGearPart> comparator) {
        this.partList.sort(comparator);
        ArrayList<PartButton> sortedList = new ArrayList<PartButton>();
        block0: for (IGearPart part : this.partList) {
            for (PartButton button : this.partButtons) {
                if (button.part != part) continue;
                sortedList.add(button);
                continue block0;
            }
        }
        this.partButtons = sortedList;
        if (reversed) {
            this.partList = Lists.reverse(this.partList);
            this.partButtons = Lists.reverse(this.partButtons);
        }
        this.layoutPartButtons();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawSelectedPartInfo();
        super.render(mouseX, mouseY, partialTicks);
        if (this.minecraft == null) {
            return;
        }
        for (Widget button : this.buttons) {
            if (!(button instanceof PartButton)) continue;
            ((PartButton)button).drawHover(this.minecraft, mouseX, mouseY);
        }
    }

    private void drawSelectedPartInfo() {
        if (this.minecraft == null) {
            return;
        }
        if (this.selectedPart != null && !this.selectedPartInfo.isEmpty()) {
            ItemStack stack = this.selectedPart.getMaterials().getDisplayItem(ClientTicks.ticksInGame());
            int scaledWidth = this.minecraft.func_228018_at_().func_198107_o();
            this.minecraft.func_175599_af().func_175042_a(stack, scaledWidth - 194, 30);
            int maxWidth = 140;
            int x = scaledWidth - 150;
            int y = 35;
            String translatedName = this.selectedPart.getDisplayName(PartData.of(this.selectedPart), ItemStack.field_190927_a).func_150254_d();
            TextRenderUtils.renderScaled((FontRenderer)this.minecraft.field_71466_p, (String)translatedName, (int)x, (int)y, (float)1.0f, (int)0xFFFFFF, (boolean)false);
            String regName = TextFormatting.GRAY + this.selectedPart.getId().toString();
            TextRenderUtils.renderScaled((FontRenderer)this.minecraft.field_71466_p, (String)regName, (int)x, (int)(y + 10), (float)0.5f, (int)0xFFFFFF, (boolean)false);
            String packName = TextFormatting.GRAY + "Data pack: " + this.selectedPart.getPackName();
            TextRenderUtils.renderScaled((FontRenderer)this.minecraft.field_71466_p, (String)packName, (int)x, (int)(y + 16), (float)0.5f, (int)0xFFFFFF, (boolean)false);
            String typeName = this.selectedPart.getType().getDisplayName(this.selectedPart.getTier()).func_150254_d();
            TextRenderUtils.renderScaled((FontRenderer)this.minecraft.field_71466_p, (String)(TextFormatting.GREEN + typeName), (int)x, (int)(y + 22), (float)0.8f, (int)0xFFFFFF, (boolean)false);
            y += 36;
            for (Tuple<String, String> pair : this.selectedPartInfo) {
                this.font.func_211126_b((String)pair.func_76341_a(), (float)x, (float)y, 0xFFFFFF);
                int width2 = this.font.func_78256_a((String)pair.func_76340_b());
                this.font.func_211126_b((String)pair.func_76340_b(), (float)(x + 140 - width2), (float)y, 0xFFFFFF);
                y += 10;
            }
        }
    }

    private static List<Tuple<String, String>> getPartInfo(IGearPart part) {
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        PartData partData = PartData.of(part);
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, modifiers)).shouldList(part, stat, true)) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.getNameColor();
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            String nameStr = nameColor + stat.getDisplayName().func_150254_d();
            int decimalPlaces = stat.isDisplayAsInt() && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statListStr = StatModifierMap.formatText(modifiers, stat, decimalPlaces).func_211708_a(statColor).func_150254_d();
            list.add((Tuple<String, String>)new Tuple((Object)nameStr, (Object)statListStr));
        }
        return list;
    }

    public static class SortButton
    extends Button {
        private final List<Pair<String, Button.IPressable>> options;
        private int selected = -1;

        SortButton(int x, int y, int widthIn, int heightIn, List<Pair<String, Button.IPressable>> optionsIn) {
            super(x, y, widthIn, heightIn, "Default", SortButton::onPress);
            this.options = new ArrayList<Pair<String, Button.IPressable>>(optionsIn);
        }

        private static void onPress(Button b) {
            SortButton button = (SortButton)b;
            ++button.selected;
            if (button.selected >= button.options.size()) {
                button.selected = 0;
            }
            Pair<String, Button.IPressable> pair = button.options.get(button.selected);
            button.setMessage((String)pair.getFirst());
            ((Button.IPressable)pair.getSecond()).onPress(b);
        }
    }

    public static class PartButton
    extends Button {
        private static final int SIZE = 16;
        final IGearPart part;

        PartButton(IGearPart part, int x, int y, Button.IPressable action) {
            this(part, x, y, 16, 16, action);
        }

        PartButton(IGearPart part, int x, int y, int widthIn, int heightIn, Button.IPressable action) {
            super(x, y, widthIn, heightIn, part.getId().toString(), action);
            this.part = part;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                ItemStack stack = this.part.getMaterials().getDisplayItem(ClientTicks.ticksInGame());
                if (stack.func_190926_b()) {
                    stack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
                }
                RenderSystem.enableRescaleNormal();
                RenderHelper.func_227780_a_();
                Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, this.x, this.y);
                RenderHelper.func_74518_a();
                RenderSystem.disableRescaleNormal();
            }
        }

        void drawHover(Minecraft mc, int mouseX, int mouseY) {
            if (this.isMouseOver(mouseX, mouseY)) {
                ItemStack craftingStack = this.part.getMaterials().getDisplayItem(ClientTicks.ticksInGame());
                List tooltip = craftingStack.func_82840_a((PlayerEntity)mc.field_71439_g, () -> false).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
                GuiUtils.preItemToolTip((ItemStack)craftingStack);
                tooltip.add(0, this.part.getDisplayName(null, ItemStack.field_190927_a).func_211708_a(TextFormatting.UNDERLINE).func_150254_d());
                MainWindow mainWindow = mc.func_228018_at_();
                GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)mainWindow.func_198105_m(), (int)mainWindow.func_198083_n(), (int)-1, (FontRenderer)mc.field_71466_p);
                GuiUtils.postItemToolTip();
            }
        }
    }
}

