/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.PartMaterial;
import net.silentchaos512.utils.Color;

public final class SGearMaterialsCommand {
    private static final SuggestionProvider<CommandSource> MATERIAL_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(MaterialManager.getValues().stream().map(IMaterial::getId), (SuggestionsBuilder)builder);
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private SGearMaterialsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"sgear_mats");
        builder.then(Commands.func_197057_a((String)"list").executes(SGearMaterialsCommand::runList));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").then(Commands.func_197056_a((String)"includeChildren", (ArgumentType)BoolArgumentType.bool()).executes(context -> SGearMaterialsCommand.runDump((CommandContext<CommandSource>)context, (Boolean)context.getArgument("includeChildren", Boolean.class))))).executes(context -> SGearMaterialsCommand.runDump((CommandContext<CommandSource>)context, true)));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = MaterialManager.getValues().stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDump(CommandContext<CommandSource> context, boolean includeChildren) {
        String dirPath = "output/silentgear";
        String fileName = "material_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Pack\tName\tType\tID\tParent\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().func_150254_d()).append("\t"));
            builder.append("Traits\tTexture\tColor\n");
            writer.write(builder.toString());
            ArrayList<PartType> partTypes = new ArrayList<PartType>(PartType.getValues());
            partTypes.sort((o1, o2) -> Comparator.comparing(o -> ((PartType)o).getName()).compare(o1, o2));
            for (PartType partType : partTypes) {
                for (IMaterial material : MaterialManager.getValues()) {
                    if (!includeChildren && !SGearMaterialsCommand.getParentId(material).isEmpty() || !material.allowedInPart(partType)) continue;
                    writer.write(SGearMaterialsCommand.makeTsvLine(material, partType) + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ITextComponent fileNameText = new StringTextComponent(output.getAbsolutePath()).func_211708_a(TextFormatting.UNDERLINE).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Wrote materials info to ").func_150257_a(fileNameText), true);
        }
        return 1;
    }

    private static String makeTsvLine(IMaterial material, PartType partType) {
        StringBuilder builder = new StringBuilder();
        SGearMaterialsCommand.appendTsv(builder, material.getPackName());
        SGearMaterialsCommand.appendTsv(builder, material.getDisplayName(partType, ItemStack.field_190927_a).getString());
        int tier = material.getTier(partType);
        SGearMaterialsCommand.appendTsv(builder, partType.getName().toString());
        SGearMaterialsCommand.appendTsv(builder, material.getId().toString());
        SGearMaterialsCommand.appendTsv(builder, SGearMaterialsCommand.getParentId(material));
        SGearMaterialsCommand.appendTsv(builder, tier);
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = material.getStatModifiers(stat, partType);
            SGearMaterialsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        SGearMaterialsCommand.appendTsv(builder, material.getTraits(partType).stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).func_150254_d()).collect(Collectors.joining(", ")));
        SGearMaterialsCommand.appendTsv(builder, (Object)material.getTexture(partType, ItemStack.field_190927_a));
        SGearMaterialsCommand.appendTsv(builder, Color.format((int)(material.getColor(ItemStack.field_190927_a, partType) & 0xFFFFFF)));
        return builder.toString();
    }

    private static String getParentId(IMaterial material) {
        IMaterial parent;
        if (material instanceof PartMaterial && (parent = ((PartMaterial)material).getParent()) != null) {
            return parent.getId().toString();
        }
        return "";
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TranslationTextComponent("command.silentgear.parts." + key, args);
    }
}

