/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;

public class ExclusionIngredient
extends Ingredient {
    private final Ingredient parent;
    private final Collection<ResourceLocation> exclusions = new ArrayList<ResourceLocation>();

    public ExclusionIngredient(Ingredient parent, Collection<ResourceLocation> exclusions) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.parent = parent;
        this.exclusions.addAll(exclusions);
    }

    public ItemStack[] func_193365_a() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(Arrays.asList(this.parent.func_193365_a()));
        this.exclusions.forEach(id -> ret.removeIf(stack -> ExclusionIngredient.isItem(id, stack)));
        return ret.toArray(new ItemStack[0]);
    }

    public IntList func_194139_b() {
        return super.func_194139_b();
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.parent.test(stack) && this.exclusions.stream().noneMatch(id -> ExclusionIngredient.isItem(id, stack));
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    private static boolean isItem(ResourceLocation id, ItemStack stack) {
        return id.equals((Object)stack.func_77973_b().getRegistryName());
    }

    public static class Serializer
    implements IIngredientSerializer<ExclusionIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("exclusion");

        @Nonnull
        public ExclusionIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.func_199802_a((JsonElement)json.get("value"));
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            json.get("exclusions").getAsJsonArray().forEach(e -> list.add(new ResourceLocation(e.getAsString())));
            return new ExclusionIngredient(value, list);
        }

        @Nonnull
        public ExclusionIngredient parse(@Nonnull PacketBuffer buffer) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                list.add(buffer.func_192575_l());
            }
            return new ExclusionIngredient(Ingredient.func_199566_b((PacketBuffer)buffer), list);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull ExclusionIngredient ingredient) {
            buffer.writeByte(ingredient.exclusions.size());
            ingredient.exclusions.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
            ingredient.parent.func_199564_a(buffer);
        }
    }
}

