/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.MaterialManager;

public final class PartMaterialIngredient
extends Ingredient {
    private final PartType type;

    private PartMaterialIngredient(PartType type) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.type = type;
    }

    public static PartMaterialIngredient of(PartType type) {
        return new PartMaterialIngredient(type);
    }

    public PartType getPartType() {
        return this.type;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        IMaterial material = MaterialManager.from(stack);
        return material != null && material.isCraftingAllowed(this.type);
    }

    public ItemStack[] func_193365_a() {
        Collection<IMaterial> materials = MaterialManager.getValues();
        if (!materials.isEmpty()) {
            return (ItemStack[])materials.stream().filter(mat -> mat.isCraftingAllowed(this.type)).flatMap(mat -> Stream.of(mat.getIngredient(this.type).func_193365_a())).filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
        }
        return super.func_193365_a();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean func_203189_d() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements IIngredientSerializer<PartMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("material");

        private Serializer() {
        }

        public PartMaterialIngredient parse(PacketBuffer buffer) {
            ResourceLocation typeName = buffer.func_192575_l();
            PartType type = PartType.get(typeName);
            if (type == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            return new PartMaterialIngredient(type);
        }

        public PartMaterialIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            ResourceLocation id = typeName.contains(":") ? new ResourceLocation(typeName) : SilentGear.getId(typeName);
            PartType type = PartType.get(id);
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            return new PartMaterialIngredient(type);
        }

        public void write(PacketBuffer buffer, PartMaterialIngredient ingredient) {
            buffer.func_192572_a(ingredient.type.getName());
        }
    }
}

